#include "CMyTreeCtrl.h"

IMPLEMENT_DYNAMIC(CMyTreeCtrl, CTreeCtrl)

BEGIN_MESSAGE_MAP(CMyTreeCtrl, CTreeCtrl)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
END_MESSAGE_MAP()

void CMyTreeCtrl::OnLButtonDown(UINT nFlags, CPoint point)
{
	UINT flag = 0;
	HTREEITEM item = HitTest(point, &flag);
	if (flag & TVHT_ONITEMLABEL)
		SelectItem(item);
	else
		SelectItem(nullptr);
	CTreeCtrl::OnLButtonDown(nFlags, point);
}

void CMyTreeCtrl::OnRButtonDown(UINT nFlags, CPoint point)
{
	if (!selectedMenu)
		return;
	UINT flag = 0;
	HTREEITEM item = HitTest(point, &flag);
	if (item != nullptr && (flag & TVHT_ONITEMLABEL))
	{
		SelectItem(item);
		// ص˵
		CMenu m, * pm;
		m.LoadMenu(selectedMenu);
		pm = m.GetSubMenu(0);

		ClientToScreen(&point);
		pm->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, GetParent());
		return;
	}
	if (notSelectedMenu)// ص˵
	{
		SelectItem(nullptr);
		CMenu m, * pm;
		m.LoadMenu(notSelectedMenu);
		pm = m.GetSubMenu(0);

		ClientToScreen(&point);
		pm->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, GetParent());
	}
}

void CMyTreeCtrl::SetMenu(int selectedMenu, int notSelectedMenu)
{
	this->selectedMenu = selectedMenu;
	this->notSelectedMenu = notSelectedMenu;
}
