#include "CMyPicBox.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CMyPicBox, CDialog)

BEGIN_MESSAGE_MAP(CMyPicBox, CDialog)
	ON_WM_PAINT()
	ON_WM_SIZE()
END_MESSAGE_MAP()

CMyPicBox::CMyPicBox(CWnd* pParent)
	: CDialog(IDD_CMYPICBOX, pParent)
{
}

CMyPicBox::~CMyPicBox()
{
	for (auto& p : loadedTexture)
	{
		if (p.second.pSRV &&
			p.second.pSRV != tas_nullpxa.pSRV)
		{
			p.second.pSRV->Release();
			p.second.pSRV = nullptr;
		}
		if (p.second.pTexture &&
			p.second.pTexture != tas_nullpxa.pTexture)
		{
			p.second.pTexture->Release();
			p.second.pTexture = nullptr;
		}
	}
	loadedTexture.clear();
	if (tas_nullpxa.pSRV)
		tas_nullpxa.pSRV->Release();
	tas_nullpxa.pSRV = nullptr;
	if (tas_nullpxa.pTexture)
		tas_nullpxa.pTexture->Release();
	tas_nullpxa.pTexture = nullptr;
}

void CMyPicBox::Draw()
{
	if (pRenderer.GetContext() == nullptr)
		return;
	pRenderer.RenderClear();
	if (picCurrent.GetLength() > 0)
	{
		auto pSRV = GetTexture(picCurrent);
		CRect rc;
		MyRect dst, adjustDst;
		pRenderer.GetRenderCopyDefaultRect(pSRV, &dst, nullptr);
		GetClientRect(&rc);
		adjustDst.Set1((float)rc.left, (float)rc.top, (float)rc.Width(), (float)rc.Height());
		dst.AdjustIn(adjustDst);
		pRenderer.SetTPenDraw(pSRV);
		pRenderer.AddRenderCopy(nullptr, &dst);
		pRenderer.DrawRenderCopy();
	}
	pRenderer.RenderPresent();
}

void CMyPicBox::SetPic(CString pngName)
{
	for (auto& p : loadedTexture)
	{
		if (p.second.pSRV)
		{
			p.second.pSRV->Release();
			p.second.pSRV = nullptr;
		}
		if (p.second.pTexture)
		{
			p.second.pTexture->Release();
			p.second.pTexture = nullptr;
		}
	}
	loadedTexture.clear();
	picCurrent = pngName;
	Draw();
}

void CMyPicBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BOOL CMyPicBox::OnInitDialog()
{
	CDialog::OnInitDialog();
	pRenderer.Init(m_hWnd);
	LoadResourceTexture(&pRenderer, IDR_NULLPXA, &tas_nullpxa.pTexture, &tas_nullpxa.pSRV);
	return 0;
}


void CMyPicBox::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// ΪͼϢ CDialog::OnPaint()
	Draw();
}


void CMyPicBox::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	
	pRenderer.OnSize(cx, cy, nType == SIZE_MINIMIZED);
	Draw();
}

ID3D11ShaderResourceView* CMyPicBox::GetTexture(CString pngName)
{
	if (loadedTexture.find(pngName.GetString()) == loadedTexture.end())
	{
		std::vector<char> utf8_buff;
		//pngName·ȫǵļ
		if (pngName.ReverseFind('\\') == -1 && pngName.ReverseFind('/') == -1)
		{
			//ļ
			CString wstr;
			wstr.Format(L"./data/png/%s", pngName.GetString());
			UTF16ToUTF8(wstr.GetString(), &utf8_buff);

			MyTextureAndSRV tas;
			pRenderer.MyLoadTexture(&tas.pTexture, utf8_buff.data());
			pRenderer.MyCreateShaderResourceView(&tas.pSRV, tas.pTexture);
			
			loadedTexture.insert(std::make_pair(pngName.GetString(), tas));
			return tas.pSRV;
		}
		else
		{
			//ȫ·
			UTF16ToUTF8(pngName.GetString(), &utf8_buff);
			//ļǷ
			MyTextureAndSRV tas;
			pRenderer.MyLoadTexture(&tas.pTexture, utf8_buff.data());
			if (tas.pTexture)
			{
				pRenderer.MyCreateShaderResourceView(&tas.pSRV, tas.pTexture);
				loadedTexture.insert(std::make_pair(pngName.GetString(), tas));
				return tas.pSRV;
			}
			else
			{
				loadedTexture.insert(std::make_pair(pngName.GetString(), tas_nullpxa));
				return tas_nullpxa.pSRV;
			}
		}
	}
	return loadedTexture.at(pngName.GetString()).pSRV;
}
