#include "CDiary.h"
#include "resource.h"
#include "CMainEditor.h"

IMPLEMENT_DYNAMIC(CDiary, CDialog)

BEGIN_MESSAGE_MAP(CDiary, CDialog)
	ON_EN_CHANGE(IDC_EDIT_DIARY, &CDiary::OnEnChangeEditDiary)
	ON_COMMAND(ID_SAVE_DIARY, &CDiary::OnSaveDiary)
END_MESSAGE_MAP()

CDiary::CDiary(CWnd* pParent)
	: CDialog(IDD_CMAINEDITOR_DIARY, pParent)
{
}

CDiary::~CDiary()
{
}

void CDiary::UpdateWindowTitle()
{
	if (CheckSaved())
	{
		CString str;
		str.Format(L"%d%d%d", year, month, day);
		SetWindowTextW(str.GetString());
	}
	else
	{
		CString str;
		str.Format(L"%d%d%d(δ)", year, month, day);
		SetWindowTextW(str.GetString());
	}
}

bool CDiary::CheckSaved()
{
	CString text;
	edit_diary.GetWindowTextW(text);
	return diary_saved == text;
}

void CDiary::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_DIARY, edit_diary);
}

BOOL CDiary::OnInitDialog()
{
	CDialog::OnInitDialog();
	//ݼ
	LOADHOTKEY(IDR_ACC_DIARY);

	CString str;
	str.Format(L"%d%d%d", year, month, day);
	SetWindowTextW(str.GetString());
	//ݿȡռ
	CMainEditor* mainEditor = (CMainEditor*)pMainEditor;
	CString dateValue;
	dateValue.Format(L"%d-%d-%d", year, month, day);
	diary_saved = mainEditor->GetDBFieldValue(DBTABLENAME_CALENDAR, L"date", dateValue.GetString(), L"diary");
	edit_diary.SetWindowTextW(diary_saved.GetString());
	return 0;
}

void CDiary::OnEnChangeEditDiary()
{
	// TODO:  ÿؼ RICHEDIT ؼ
	// ʹ֪ͨд CDialog::OnInitDialog()
	//  CRichEditCtrl().SetEventMask()
	// ͬʱ ENM_CHANGE ־㵽С

	UpdateWindowTitle();
}


void CDiary::OnSaveDiary()
{
	//ݵݿ
	CMainEditor* mainEditor = (CMainEditor*)pMainEditor;
	edit_diary.GetWindowTextW(diary_saved);
	CString dateValue;
	dateValue.Format(L"%d-%d-%d", year, month, day);
	if (diary_saved.GetLength() > 0)
		mainEditor->SetDBFieldValue(DBTABLENAME_CALENDAR, L"date", dateValue.GetString(), L"diary", diary_saved.GetString());
	else
		mainEditor->DelDBField(DBTABLENAME_CALENDAR, L"date", dateValue.GetString());
	UpdateWindowTitle();
	mainEditor->UpdateDisplayDiary();
	mainEditor->UpdateWindowTitle();
	mainEditor->Draw();
}

BOOL CDiary::PreTranslateMessage(MSG* pMsg)
{
	HOTKEYPROC;
}