#include "CCalendarBK.h"
#include "resource.h"
#include "CMainEditor.h"
IMPLEMENT_DYNAMIC(CCalendarBK, CDialog)

BEGIN_MESSAGE_MAP(CCalendarBK, CDialog)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_ALPHA, &CCalendarBK::OnNMCustomdrawSliderAlpha)
	ON_BN_CLICKED(IDC_DIR, &CCalendarBK::OnBnClickedDir)
	ON_BN_CLICKED(IDOK, &CCalendarBK::OnBnClickedOk)
END_MESSAGE_MAP()

CCalendarBK::CCalendarBK(CWnd* pParent)
	: CDialog(IDD_CMAINEDITOR_BK, pParent)
{
}

CCalendarBK::~CCalendarBK()
{
}

void CCalendarBK::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_DIR, edit_dir);
	DDX_Control(pDX, IDC_SLIDER_ALPHA, slider_alpha);
	label_alpha_value = (CStatic*)GetDlgItem(IDC_STATIC_VALUE);
}

BOOL CCalendarBK::OnInitDialog()
{
	CDialog::OnInitDialog();
	//ÿؼʼ״̬
	slider_alpha.SetRangeMax(255);
	slider_alpha.SetRangeMin(0);
	auto mainEditor = (CMainEditor*)pMainEditor;
	CString calendar_bk_file = mainEditor->GetDBFieldValue(DBTABLENAME_OPTION, L"field", L"calendar_bk_filename", L"value").GetString();
	edit_dir.SetWindowTextW(calendar_bk_file.GetString());
	CString calendar_bk_alpha = mainEditor->GetDBFieldValue(DBTABLENAME_OPTION, L"field", L"calendar_bk_alpha", L"value").GetString();
	if (calendar_bk_alpha.GetLength() == 0)
		calendar_bk_alpha = L"255";
	label_alpha_value->SetWindowTextW(calendar_bk_alpha.GetString());
	int pos;
	swscanf_s(calendar_bk_alpha.GetString(), L"%d", &pos);
	slider_alpha.SetPos(pos);
	return 0;
}


void CCalendarBK::OnNMCustomdrawSliderAlpha(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	
	CString str;
	str.Format(L"%d", slider_alpha.GetPos());
	label_alpha_value->SetWindowTextW(str.GetString());
	*pResult = 0;
	auto mainEditor = (CMainEditor*)pMainEditor;
	mainEditor->alpha = mainEditor->alpha_bkup = (BYTE)slider_alpha.GetPos();
	mainEditor->Draw();
}


void CCalendarBK::OnBnClickedDir()
{
	CFileDialog fd(true, TEXT(""), TEXT(""), OFN_FILEMUSTEXIST, TEXT("WEBPͼļ(*.webp)|*.webp|PNGͼļ(*.png)|*.png|JPEGͼļ(*.jpg)|*.jpg|ļ(*.*)|*.*||"), this);
	if (fd.DoModal() != IDOK)
		return;
	edit_dir.SetWindowTextW(fd.GetPathName().GetString());
	//޸˱ʾЧ
	auto mainEditor = (CMainEditor*)pMainEditor;
	std::vector<char> filename_utf8;
	UTF16ToUTF8(fd.GetPathName().GetString(), &filename_utf8);
	if (mainEditor->pTextureBk_bkup)
	{
		mainEditor->pTextureBk_bkup->Release();
		mainEditor->pTextureBk_bkup = nullptr;
	}
	if (mainEditor->pSRV_bkup)
	{
		mainEditor->pSRV_bkup->Release();
		mainEditor->pSRV_bkup = nullptr;
	}
	mainEditor->pRenderer.MyLoadTexture(&mainEditor->pTextureBk_bkup, filename_utf8.data());
	mainEditor->pRenderer.MyCreateShaderResourceView(&mainEditor->pSRV_bkup, mainEditor->pTextureBk_bkup);
	mainEditor->Draw();
}

void CCalendarBK::OnBnClickedOk()
{
	
	//ȷ 鱾pngĿ¼ûͬļ
	//ȡpngļĿ¼
	auto mainEditor = (CMainEditor*)pMainEditor;
	auto pngPath = mainEditor->GetBasePath();
	pngPath.Append(L"data\\png\\");
	CString otherPngPath;
	edit_dir.GetWindowTextW(otherPngPath);
	CString otherPngName = otherPngPath.GetString() + otherPngPath.ReverseFind(L'\\') + 1;
	CString localPngPath = pngPath;
	localPngPath.Append(otherPngName);
	//ֶ
	outFileName = otherPngName;
	outAlpha.Format(L"%d", slider_alpha.GetPos());
	//ѡͼļǲǾǱpngĿ¼
	if (otherPngPath == localPngPath)
	{
		//ͬһĿ¼ֱ
		CDialog::OnOK();
		return;
	}
	else
	{
		CString thisPngPath = pngPath;
		thisPngPath.Append(otherPngPath);
		if (thisPngPath == localPngPath)
		{
			//ͬһĿ¼ֱ
			CDialog::OnOK();
			return;
		}
	}
	//ͬһĿ¼
	//ûдͬļ
	FILE* fp;
	_wfopen_s(&fp, localPngPath.GetString(), L"r");
	if (fp)
	{
		fclose(fp);
		//ͬļ
		CString info;
		info.Format(L"pngĿ¼´ͬļ%s\nǷ滻", otherPngName.GetString());
		switch (MessageBoxW(info.GetString(), L"Ƿ滻ļ", MB_ICONINFORMATION | MB_YESNO))
		{
		case IDYES://ԭļ
			CopyFileW(otherPngPath.GetString(), localPngPath.GetString(), false);
			CDialog::OnOK();
			return;
		case IDCANCEL://
		case IDNO:
			return;
		}
	}
	//ͬļ ֱӸ
	CopyFileW(otherPngPath.GetString(), localPngPath.GetString(), false);
	CDialog::OnOK();
}
