#include "CAniEditorDrawGrid.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CAniEditorDrawGrid, CDialog)

BEGIN_MESSAGE_MAP(CAniEditorDrawGrid, CDialog)
	ON_BN_CLICKED(IDOK, &CAniEditorDrawGrid::OnBnClickedOk)
END_MESSAGE_MAP()

CAniEditorDrawGrid::CAniEditorDrawGrid(CWnd* pParent)
	: CDialog(IDD_CANIEDITOR_DRAW_GRID, pParent)
{
}

CAniEditorDrawGrid::~CAniEditorDrawGrid()
{
}

void CAniEditorDrawGrid::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_GRID_W, edit_grid_w);
	DDX_Control(pDX, IDC_EDIT_GRID_H, edit_grid_h);
	DDX_Control(pDX, IDC_EDIT_COUNT_W, edit_count_w);
	DDX_Control(pDX, IDC_EDIT_COUNT_H, edit_count_h);
	DDX_Control(pDX, IDC_CHECK_SHOWBK, check_showBk);
	DDX_Control(pDX, IDC_CHECK_SHOWLINE, check_showLine);
	DDX_Control(pDX, IDC_CHECK_SHOWENTITY, check_showEntity);
	DDX_Control(pDX, IDC_RADIO_DARK, radio_dark);
	DDX_Control(pDX, IDC_RADIO_LIGHT, radio_light);
}

BOOL CAniEditorDrawGrid::OnInitDialog()
{
	CDialog::OnInitDialog();
	//Ĭֵ
	SetDlgItemInt(IDC_EDIT_GRID_W, outGridW);
	SetDlgItemInt(IDC_EDIT_GRID_H, outGridH);
	SetDlgItemInt(IDC_EDIT_COUNT_W, outCountW);
	SetDlgItemInt(IDC_EDIT_COUNT_H, outCountH);
	check_showBk.SetCheck(outShowBk);
	check_showLine.SetCheck(outShowLine);
	check_showEntity.SetCheck(outShowEntity);
	if (outIsDark)
	{
		radio_dark.SetCheck(true);
		radio_light.SetCheck(false);
	}
	else
	{
		radio_dark.SetCheck(false);
		radio_light.SetCheck(true);
	}
	return 0;
}


void CAniEditorDrawGrid::OnBnClickedOk()
{
	//
	CString strGrid_w;
	edit_grid_w.GetWindowTextW(strGrid_w);
	if (strGrid_w.GetLength() == 0)
	{
		MessageBox(L"д", L"дЧ");
		return;
	}
	int grid_w = GetDlgItemInt(IDC_EDIT_GRID_W);
	if (grid_w == 0)
	{
		MessageBox(L"Ϊ1", L"дЧ");
		return;
	}
	//߶
	CString strGrid_h;
	edit_grid_h.GetWindowTextW(strGrid_h);
	if (strGrid_h.GetLength() == 0)
	{
		MessageBox(L"д߶", L"дЧ");
		return;
	}
	int grid_h = GetDlgItemInt(IDC_EDIT_GRID_H);
	if (grid_h == 0)
	{
		MessageBox(L"߶Ϊ1", L"дЧ");
		return;
	}
	//
	CString strCount_w;
	edit_count_w.GetWindowTextW(strCount_w);
	if (strCount_w.GetLength() == 0)
	{
		MessageBox(L"д", L"дЧ");
		return;
	}
	int count_w = GetDlgItemInt(IDC_EDIT_COUNT_W);
	if (count_w == 0)
	{
		MessageBox(L"Ϊ1", L"дЧ");
		return;
	}
	//
	CString strCount_h;
	edit_count_h.GetWindowTextW(strCount_h);
	if (strCount_h.GetLength() == 0)
	{
		MessageBox(L"д", L"дЧ");
		return;
	}
	int count_h = GetDlgItemInt(IDC_EDIT_COUNT_H);
	if (count_h == 0)
	{
		MessageBox(L"Ϊ1", L"дЧ");
		return;
	}
	//񱳾
	bool bShowBk = check_showBk.GetCheck();
	//
	bool bShowLine = check_showLine.GetCheck();
	//ʵ߿
	bool bShowEntity = check_showEntity.GetCheck();
	//ɫ
	bool bIsDark = true;
	if (radio_dark.GetCheck())
		bIsDark = true;
	else if (radio_light.GetCheck())
		bIsDark = false;
	//
	outGridW = grid_w;
	outGridH = grid_h;
	outCountW = count_w;
	outCountH = count_h;
	outShowBk = bShowBk;
	outShowLine = bShowLine;
	outShowEntity = bShowEntity;
	outIsDark = bIsDark;
	CDialog::OnOK();
}
