#include "EntityStateGravity.h"
const int ES_STATENAME_GRAVITY = GetNextEntityStateID();
const int ES_STATENAME_FLY = GetNextEntityStateID();
EntityStateGravity::EntityStateGravity()
{
	enable = true;
	SetPhysice(false);
	gravity = gravity_default;
	stateID = ES_STATENAME_GRAVITY;
}

void EntityStateGravity::State()
{
	auto we = e.lock();
	if (!we)
		return;
	//ʱסԾܸı
	if (we->vy > 0)//ָ
		gravity = gravity_default * gravity_scale;
	if (we->vy + gravity * gravity_scale < max_fall_speed * gravity_scale)
	{
		we->vy += gravity * gravity_scale;
		if (we->vy > max_fall_speed * gravity_scale)
			we->vy = max_fall_speed * gravity_scale;
	}
}

void EntityStateGravity::ChangeStateMsg(int stateID)
{
	if (stateID == ES_STATENAME_FLY)
		enable = false;
	else
		enable = true;
}

void EntityStateGravity::SetPhysice(bool bInWater)
{
	if (bInWater)
	{
		gravity_default = inwater_gravity_default;
		max_fall_speed = inwater_max_fall_speed;
	}
	else
	{
		gravity_default = ground_gravity_default;
		max_fall_speed = ground_max_fall_speed;
	}
}

void EntityStateGravity::SetGravityScale(float scale)
{
	gravity_scale = scale;
}

void EntityStateGravity::SetGravity(float gravity)
{
	this->gravity = gravity;
}

float EntityStateGravity::GetGravityDefault()
{
	return gravity_default;
}

float EntityStateGravity::GetMaxFallSpeed()
{
	return max_fall_speed;
}
