#include "MenuResetKey_Player1Keyboard.h"

#include "MenuTextUp_Player1Keyboard.h"
#include "MenuTextDown_Player1Keyboard.h"
#include "MenuTextLeft_Player1Keyboard.h"
#include "MenuTextRight_Player1Keyboard.h"
#include "MenuTextOk_Player1Keyboard.h"
#include "MenuTextCancel_Player1Keyboard.h"
#include "MenuTextJump_Player1Keyboard.h"
#include "MenuTextAtk_Player1Keyboard.h"
#include "MenuTextMenu_Player1Keyboard.h"
#include "MenuTextInventory_Player1Keyboard.h"
#include "MenuTextMap_Player1Keyboard.h"
#include "MenuTextPagePrev_Player1Keyboard.h"
#include "MenuTextPageNext_Player1Keyboard.h"
#include "MenuTextSk1_Player1Keyboard.h"
#include "MenuTextSk2_Player1Keyboard.h"
#include "MenuTextSk3_Player1Keyboard.h"
#include "MenuTextSk4_Player1Keyboard.h"
#include "MenuTextSk5_Player1Keyboard.h"
#include "MenuTextSk6_Player1Keyboard.h"
#include "MenuTextSwitchMc_Player1Keyboard.h"
MenuResetKey_Player1Keyboard::MenuResetKey_Player1Keyboard()
{
	ani.png = L"menu_CS_title";
	ani.sprite_index = L"msg_reset";
}

void MenuResetKey_Player1Keyboard::Step()
{
	if (gameFunc->GetInputSetting_Player1Keyboard)
	{
		if (gameFunc->GetKey(SDL_SCANCODE_ESCAPE))
		{
			if (counter == 1)
			{
				gameFunc->PlaySound(L"MenuCancel");
				gameFunc->ResetKeySetting_Player1Keyboard();
				gameFunc->SaveConfig();
				//޸bug
				std::weak_ptr<Entity> eArr[] = {
					GetEntityByType(MENUTEXTUP_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTMAP_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTDOWN_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTJUMP_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTLEFT_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTATK_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTRIGHT_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK1_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTOK_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK2_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTCANCEL_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK3_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTMENU_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK4_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTINVENTORY_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK5_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTPAGEPREV_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSK6_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTPAGENEXT_PLAYER1KEYBOARD_CREATENAME),
					GetEntityByType(MENUTEXTSWITCHMC_PLAYER1KEYBOARD_CREATENAME)
				};
				for (int i = 0; i < _countof(eArr); i++)
				{
					auto we = eArr[i].lock();
					if (we)
					{
						we->ani.png = we->ani.sprite_index = L"";
						we->el.flag.text = true;
						we->SetState(0, 0);
					}
				}
			}	
			if (counter > 0)
				counter--;
		}
		else
			counter = counter_max;
		if (counter == 0)
		{
			ani.sprite_index = L"msg_resetDone";
		}
		else if (counter >= counter_max)
		{
			ani.sprite_index = L"msg_reset";
		}
		else
		{
			int num = counter / 40;
			if (num >= 0 && num <= 4)
			{
				wchar_t buff[MAX_PATH];
				swprintf_s(buff, L"msg_count%d", num);
				ani.sprite_index = buff;
			}
		}
	}
}

std::weak_ptr<Entity> MenuResetKey_Player1Keyboard::GetEntityByType(const wchar_t* name)
{
	auto loadedEntity = gameFunc->GetLoadedEntity(gameFunc->entityRes);
	for (auto& p : *loadedEntity)
	{
		for (auto& e : p.second.Ls)
		{
			if (e->el.name == name)
				return e;
		}
	}
	return std::weak_ptr<Entity>();
}

std::shared_ptr<Entity> CreateMenuResetKey_Player1Keyboard()
{
	return std::make_shared<MenuResetKey_Player1Keyboard>();
}