#include "CS_Terminal.h"

CS_Terminal::CS_Terminal()
{
	ani.png = L"CS_CaveStoryMod";
	drawBeforeOtherEntity = true;
	cbRect.left = cbRect.right = 5;
}

void CS_Terminal::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		ani_no = 0;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (abs(x - wplayer->x) < 8 && y - 16 < wplayer->y && y + 8 > wplayer->y)
				{
					gameFunc->PlaySound(L"CS_043_computer_beep");
					act_no = 1;
				}
			}
		}
		break;
	case 1:
		if (++ani_no > 2)
			ani_no = 1;
		break;
	}
}

void CS_Terminal::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_terminal_l" : L"ls_terminal_r";
}

void CS_Terminal::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"wake_up")
	{
		gameFunc->PlaySound(L"CS_043_computer_beep");
		act_no = 1;
	}
}

std::shared_ptr<Entity> CreateCS_Terminal()
{
	return std::make_shared<CS_Terminal>();
}
