#include "CS_SkullheadSetter.h"
#include "CS_Enemy_Skullhead.h"
#include "CS_PeSmoke.h"
CS_SkullheadSetter::CS_SkullheadSetter()
{
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 5 * 16;
}

void CS_SkullheadSetter::Init(std::weak_ptr<Entity> self)
{
	if (el.arg.length() && ParseInts(el.arg.c_str(), argbuff))
	{
		if (argbuff.size() == 4)
		{
			cbRect.left = 16.0f * argbuff[0];
			cbRect.right = 16.0f * argbuff[1];
			cbRect.top = 16.0f * argbuff[2];
			cbRect.bottom = 16.0f * argbuff[3];
		}
	}
	Entity::Init(self);
}

void CS_SkullheadSetter::Step()
{
	bool bSet = true;
	if (setInterval > 0)
		setInterval--;
	GridTouch();
	//Ѱбû
	//ûһ
	for (auto& e : touchList)
	{
		auto we = e.lock();
		if (we)
		{
			if (we->el.name == CS_ENEMY_SKULLHEAD_CREATENAME)
			{
				bSet = false;
				return;
			}
		}
	}
	if (bSet && setInterval == 0)
	{
		auto e = std::make_shared<CS_Enemy_Skullhead>();
		e->x = x;
		e->y = y;
		gameFunc->SetEntity(shared_from_this(), e);
		for (size_t i = 0; i < 8; i++)
		{
			int offset_x = Random((int)-cbRect.left, (int)cbRect.right);
			int offset_y = Random((int)-cbRect.top, (int)cbRect.bottom);
			auto e = std::make_shared<CS_PeSmoke>();
			e->x = x + offset_x;
			e->y = y + offset_y;
			gameFunc->SetEntity(shared_from_this(), e);
		}
		setInterval = 30;
	}
}

std::shared_ptr<Entity> CreateCS_SkullheadSetter()
{
	return std::make_shared<CS_SkullheadSetter>();
}
