#include "CS_SavePointWater.h"
#include "CS_PeSaved.h"
CS_SavePointWater::CS_SavePointWater()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_savepoint_water_dark";
	cbRect.enableCbRect = true;
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	drawBeforeOtherEntity = true;
}

void CS_SavePointWater::Step()
{
	if (action_timecounter > 0)
		action_timecounter--;
	switch (stateID)
	{
	case 0:
		ani.sprite_index = L"ls_savepoint_water_dark";
		break;
	case 1:
		ani.sprite_index = L"ls_savepoint_water_light";
		if (action_timecounter == 0)
			stateID = 0;
		break;
	}
}

void CS_SavePointWater::SetState(int stateID, int lr)
{
	this->stateID = stateID;
	this->lr = lr;
	switch (stateID)
	{
	case 0:
		ani.sprite_index = L"ls_savepoint_water_dark";
		break;
	case 1:
		ani.sprite_index = L"ls_savepoint_water_light";
		SetCS_PeSaved(shared_from_this(), x, y);
		action_timecounter = 180;
		break;
	}
}

void CS_SavePointWater::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	if (stateName == L"saved")
		SetState(1, lr);
}

std::shared_ptr<Entity> CreateCS_SavePointWater()
{
	return std::make_shared<CS_SavePointWater>();
}
