#pragma once
#include "Entity.h"
#include "CS_PeLightFade.h"
//
class CS_SantaGhostFireBlade :
    public Entity
{
public:
    CS_SantaGhostFireBlade(std::shared_ptr<Entity> parent, int level, int birthTime = 0);
    void Step() override;
    void Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy) override;
    void Feedback(std::weak_ptr<Entity> target) override;
    void AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage) override;
    void SetDir(int dirNum);
    int SpeedGetDir();
    void SetLevel(int level);
    void LevelDownStep();
    void TailStep();
    void SetCbRect_Entity();
    void SetCbRect_Collision();
    void Destroy() override;
    std::weak_ptr<CS_PeLightFade> peLight;
    std::weak_ptr<CS_PeLightFade> peLightColor;
    int level = 0;
    int dmg = 0;
    int birthTime_counter = 0;
    float moveSpeed = 0;
    int levelDownTime_counter_max = 600;
    int levelDownTime_counter = levelDownTime_counter_max;
    int tailTime_counter_max = 30;
    int tailTime_counter = 1;
};

