#include "CS_SantaGhostFire.h"
#include "CS_Santa.h"
#include "CS_SantaGhostFireBlade.h"
const int CS_SantaSTATENAME_GHOSTFIRE = GetNextEntityStateID();
CS_SantaGhostFire::CS_SantaGhostFire()
{
	stateID = CS_SantaSTATENAME_GHOSTFIRE;
	cd_counter = 0;
	cd_counter_max = 60;
	iconIndex = 2;
}

const wchar_t* CS_SantaGhostFire::GetSaveName()
{
	return L"GhostFire";
}

const wchar_t* CS_SantaGhostFire::GetFuncName()
{
	return L"SantaSkill_GhostFire";
}

const wchar_t* CS_SantaGhostFire::GetCheckFuncName()
{
	return L"SantaSkill_GhostFire_Check";
}

void CS_SantaGhostFire::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Santa>(we);
	bool a1 = !lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	//
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (cd_counter > 0)
		cd_counter--;
	//ȼ
	if (mychar->mp >= 30)
		level = 2;
	else if (mychar->mp >= 10)
		level = 1;
	else
		level = 0;
	EntitySkillState::SubStep();
}

void CS_SantaGhostFire::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		//ʼ
		auto we = e.lock();
		if (!we)
			return;
		auto mychar = std::static_pointer_cast<CS_Santa>(we);
		enable = false;
		//
		cd_counter = cd_counter_max;
		//ȼ
		if (mychar->mp >= 30)
			level = 2;
		else if (mychar->mp >= 10)
			level = 1;
		else
			level = 0;
		//
		auto am = std::make_shared<CS_SantaGhostFireBlade>(mychar, level + 1);
		we->gameFunc->SetEntity(mychar, am);
		//סüܼ
		mychar->inputLock.key |= keyMask;
	}
	else
		enable = false;
}
