#include "CS_SantaFireballBlade.h"
#include "CS_Santa.h"
#include "CS_PePhoton.h"
#include "CS_PeGunShotSpark.h"
#include "CS_SantaFireballBladeTrail.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"
CS_SantaFireballBlade::CS_SantaFireballBlade(std::shared_ptr<Entity> parent, int level)
{
	type = 2;
	attackParent = parent;
	this->level = level;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	if (ud == -1)
	{
		direct = 1;
		if (lr == 0)
			x = parent->x - 4;
		else
			x = parent->x + 4;
		y = parent->y - 12;
		SetCS_PeGunShotSpark(parent, x, y);
		x = parent->x;//
		y = parent->y - 8;//
	}
	else if (ud == 0)
	{
		y = parent->y;
		if (lr == 0)
		{
			direct = 0;
			x = parent->x - 12;
			SetCS_PeGunShotSpark(parent, x, y);
			x = parent->x - 7;//
		}
		else
		{
			direct = 2;
			x = parent->x + 12;
			SetCS_PeGunShotSpark(parent, x, y);
			x = parent->x + 7;//
		}
	}
	else
	{
		direct = 3;
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 10;
		SetCS_PeGunShotSpark(parent, x, y);
		x = parent->x;//
		y = parent->y + 8;//
	}
	//Ч
	parent->gameFunc->PlaySound(L"CS_034_fireball");
	switch (direct)
	{
	case 0:
		vx = -0x400 / ts;
		break;
	case 1:
		vx = parent->vx;

		if (parent->vx < 0)
			direct = 0;
		else
			direct = 2;

		if (parent->lr == 0)
			vx -= 0x80 / ts;
		else
			vx += 0x80 / ts;

		vy = -0x5FF / ts;
		break;
	case 2:
		vx = 0x400 / ts;
		break;
	case 3:
		vx = parent->vx;

		if (parent->vx < 0)
			direct = 0;
		else
			direct = 2;
		vy = 0x5FF / ts;
		break;
	}

	//ù
	auto wpeLight = std::make_shared<CS_PeLightFade>();
	peLight = wpeLight;
	parent->gameFunc->SetEntity(parent, wpeLight);
	wpeLight->SetRadius(1);
	wpeLight->last_x = wpeLight->x = x;
	wpeLight->last_y = wpeLight->y = y;
	initCollision = false;
	//
	damaged_limit = 2;
	damage_reset_counter = 0;
}

void CS_SantaFireballBlade::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
	{
		ani.png = L"CS_CaveStoryMod";
		ani.sprite_index = L"am_fireball";
	}
	FireballStep();
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ǽײ
	SetCbRect_Collision();
	//ִײ
	Entity::Collision();
	//ʵײ
	SetCbRect_Entity();
	//
	auto wpeLight = peLight.lock();
	if (wpeLight)
	{
		wpeLight->x = x;
		wpeLight->last_x = last_x;
		wpeLight->y = y;
		wpeLight->last_y = last_y;
	}
}

void CS_SantaFireballBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (level == 0)
		*outDamage = 2;
	else
		*outDamage = 3;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 1;//
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_SantaFireballBlade::Feedback(std::weak_ptr<Entity> target)
{
	if (damaged_counter == damaged_limit)
		Destroy();
}

void CS_SantaFireballBlade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

void CS_SantaFireballBlade::SetCbRect_Entity()
{
	cbRect.left = 8;
	cbRect.right = 8;
	cbRect.top = 16;
	cbRect.bottom = 16;
}

void CS_SantaFireballBlade::SetCbRect_Collision()
{
	cbRect.left = 3;
	cbRect.right = 3;
	cbRect.top = 3;
	cbRect.bottom = 3;
}

void CS_SantaFireballBlade::FireballStep()
{
	static const int imageIndex_left1[4] = { 0,1,2,3 };
	static const int imageIndex_right1[4] = { 4,5,6,7 };
	static const int imageIndex_left2[3] = { 8,9,10 };
	static const int imageIndex_right2[3] = { 10,9,8 };
	if (++count1 > life_count)
	{
		SetCS_PeGunShotSpark(shared_from_this(), x, y);
		Destroy();
	}
	else
	{
		BOOL bBreak = FALSE;
		if (cbRect.cbTop && cbRect.cbBottom)
			bBreak = TRUE;
		if (cbRect.cbLeft && cbRect.cbRight)
			bBreak = TRUE;

		if (direct == 0 && cbRect.cbLeft)
			direct = 2;
		if (direct == 2 && cbRect.cbRight)
			direct = 0;

		if (bBreak)
		{
			SetCS_PePhoton(shared_from_this(), x, y);
			gameFunc->PlaySound(L"CS_028_shot_hit");
			Destroy();
		}
		else
		{
			if (cbRect.cbBottom)
				vy = -0x400 / ts;
			else if (cbRect.cbLeft)
				vx = 0x400 / ts;
			else if (cbRect.cbRight)
				vx = -0x400 / ts;
			vy += 85 / ts;
			if (vy > 0x3FF / ts)
				vy = 0x3FF / ts;
			if (cbRect.cbLeft ||
				cbRect.cbRight ||
				cbRect.cbBottom)
				gameFunc->PlaySound(L"CS_034_fireball");
			ani_no++;
			if (level == 0)
			{
				if (ani_no > 3)
					ani_no = 0;
				if (direct == 0)
					ani.image_index = imageIndex_left1[ani_no];
				else
					ani.image_index = imageIndex_right1[ani_no];
			}
			else
			{
				if (ani_no > 2)
					ani_no = 0;

				if (direct == 0)
					ani.image_index = imageIndex_left2[ani_no];
				else
					ani.image_index = imageIndex_right2[ani_no];
				if (level == 1)
					SetCS_SantaFireballBladeTrail(shared_from_this(), x, y, ani_no, -1, level);
				else
					SetCS_SantaFireballBladeTrail(shared_from_this(), x, y, ani_no + 3, -1, level);
			}
		}
	}
}

void CS_SantaFireballBlade::Destroy()
{
	auto wpeLight = peLight.lock();
	if (wpeLight)
		wpeLight->Destroy();
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		auto mychar = std::static_pointer_cast<CS_Santa>(wattackParent);
		auto& amList = mychar->skillFireball.amList;
		for (auto iter = amList.begin(); iter != amList.end(); iter++)
		{
			if ((*iter).lock() == shared_from_this())
			{
				amList.erase(iter);
				break;
			}
		}
	}
	Entity::Destroy();
}
