#include "CS_QuoteAni.h"
#include "CS_PeSmoke.h"

CS_QuoteAni::CS_QuoteAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	ani.hideLayerList.insert(4);
	ani.hideLayerList.insert(5);
	ani.hideLayerList.insert(6);
	ani.hideLayerList.insert(7);
	ani.hideLayerList.insert(8);
	ani.hideLayerList.insert(9);
	ani.hideLayerList.insert(10);
}

void CS_QuoteAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_QuoteAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	switch (stateID)
	{
	case 0://վ
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_QuoteAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_quote_stand_l" : L"mc_quote_stand_r";
		if (ud == -1)
			ani.sprite_index.append(L"u");
		break;
	case 1://·
		{
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			const wchar_t* move = L"";
			if (ud == -1)
				move = lr == 0 ? L"mc_quote_move_lu" : L"mc_quote_move_ru";
			else
				move = lr == 0 ? L"mc_quote_move_l" : L"mc_quote_move_r";
			ani.sprite_index = move;
		}
		break;
	case 2://
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_quote_back_l" : L"mc_quote_back_r";
		break;
	case 3://ڵ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_quote_lie_l" : L"mc_quote_lie_r";
		break;
	case 10://˵
		ani.sprite_index = L"mc_quote_bill";
		ani.image_index = lr == 0 ? 0 : 1;
		break;
	}
}

void CS_QuoteAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"lie")
		SetState(3, lr);
	else if (stateName == L"smoke")
	{
		for (int i = 0; i < 4; i++)
		{
			auto pe = std::make_shared<CS_PeSmoke>();
			pe->x = x + Random(-12, 12);
			pe->y = y + Random(-12, 12);
			pe->vx = Random(-341, 341) / ts;
			pe->vy = Random(-0x600, 0) / ts;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
	}
	else if (stateName == L"bill")
		SetState(10, lr);
	else if (stateName == L"topdraw")
		topDraw = lr != 0;
	else if (stateName == L"show_missile")
	{
		if (lr == 0)
			ani.hideLayerList.insert(8);
		else
			ani.hideLayerList.erase(8);
	}
}

std::shared_ptr<Entity> CreateCS_QuoteAni()
{
	return std::make_shared<CS_QuoteAni>();
}
