#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "CS_QuoteGravity.h"
#include "CS_QuoteWater.h"
#include "CS_QuoteDrown.h"
#include "CS_QuoteControl.h"
#include "CS_QuoteResist.h"
#include "CS_QuoteJump.h"
#include "CS_QuoteStand.h"
#include "CS_QuoteMove.h"
#include "CS_QuoteAir.h"
#include "CS_QuoteFaceToBack.h"
#include "CS_QuoteHurt.h"
#include "CS_QuoteBooster.h"
#include "CS_QuoteTeleport.h"
#include "CS_QuoteFire.h"
#include "CS_QuoteSpur.h"
#include "CS_QuoteSuperMissile.h"
#include "CS_QuoteLock.h"
#include "CS_PeAirTankBubble.h"
#define CS_QUOTE_CREATENAME L"CS_mychar_quote"
//ҽɫ 
class CS_Quote :
    public MyCharEntity
{
public:
    CS_Quote();
    void Init(std::weak_ptr<Entity> self) override;
    void Step() override;
    void SetState(int stateID, int lr) override;
    void SetState(std::wstring stateName, int lr) override;
    void LoadSaveData() override;//ر
    void WriteSaveData() override;//д뱣
    bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
    void Gain(std::weak_ptr<Entity> item) override;
    void Destroy() override;
    void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
    void CrushDeath();
    //ͼʾ
    float animation_moveSpeed = 0x200 / ts;
    bool animation_delay = false;//·ӳһ֡뵽
    bool fishState = false;//̬
    int fishState_counter = 0;
    float floatSrcX = 0;//λ
    float floatSrcY = 0;
    bool bSetTarget = false;
    std::weak_ptr<Entity> animation_target;
    bool bSetLanding = false;
    //״̬ģ
    EntityStateFlashEffect stateFlash;
    EntityStateInvincible stateInvincible;
    CS_QuoteGravity stateGravity;
    CS_QuoteWater stateWater;
    CS_QuoteDrown stateDrown;
    CS_QuoteControl stateControl;
    CS_QuoteResist stateResist;
    CS_QuoteJump stateJump;
    CS_QuoteStand stateStand;
    CS_QuoteMove stateMove;
    CS_QuoteAir stateAir;
    CS_QuoteFaceToBack stateFaceToBack;
    CS_QuoteHurt stateHurt;
    CS_QuoteBooster stateBooster;
    CS_QuoteTeleport stateTeleport;
    //ģ
    EntitySkillState* lastGun = nullptr;
    CS_QuoteFire skillFire;
    CS_QuoteSpur skillSpur;
    CS_QuoteSuperMissile skillSuperMissile;
    CS_QuoteLock skillLock;
    //
    std::wstring crushEvent;
    //ƿЧ
    std::weak_ptr<CS_PeAirTankBubble> airTankBubble;
private:
    void GunAnimate();//
};

std::shared_ptr<Entity> CreateCS_Quote();