#include "CS_PuppyBiteBlade.h"

CS_PuppyBiteBlade::CS_PuppyBiteBlade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	ud = parent->ud;
	lr = parent->lr;
	cbRect.left = parent->cbRect.left;
	cbRect.right = parent->cbRect.right;
	cbRect.top = parent->cbRect.top;
	cbRect.bottom = parent->cbRect.bottom;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_PuppyBiteBlade::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	ignoreCaught_counter = wattackParent->ignoreCaught_counter;
	x = wattackParent->x;
	last_x = wattackParent->last_x;
	y = wattackParent->y;
	last_y = wattackParent->last_y;
	if (wattackParent->cbRect.cbBottom)
		Destroy();
}

std::weak_ptr<Entity> CS_PuppyBiteBlade::BeginCaught(std::weak_ptr<Entity> e)
{
	return attackParent;
}

void CS_PuppyBiteBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}
