#include "CS_PeRectLight.h"

CS_PeRectLight::CS_PeRectLight()
{
	light.usingLight = true;
}

void CS_PeRectLight::Step()
{
	fillList_set_last.swap(fillList_set);
	float offx = -8, offy = -8;
	DWORD c = 0xffffffff;
	AddFillFadeRect(fillList_set, 0, offx, offy, w * 16 + offx, h * 16 + offy, 16, c, c, c, c);
}

void CS_PeRectLight::DeltaTime(float deltaTime)
{
	//λ
	if (fillList.size() < fillList_set_last.size())
		fillList.resize(fillList_set_last.size());
	for (int i = 0; i < fillList_set_last.size(); i++)
	{
		auto& dst = fillList[i];
		auto& src_last = fillList_set_last[i];
		auto& src = fillList_set[i];
		dst.x = lerp(src_last.x, src.x, deltaTime);
		dst.y = lerp(src_last.y, src.y, deltaTime);
		dst.c = src.c;
	}
	Entity::DeltaTime(deltaTime);
}

void CS_PeRectLight::SetState(int stateID, int lr)
{
	if (el.arg.length() && ParseInts(el.arg.c_str(), argbuff))
	{
		if (argbuff.size() >= 2)
		{
			w = (float)argbuff[0];
			h = (float)argbuff[1];
		}
		el.arg.clear();
	}
}

std::shared_ptr<Entity> CreateCS_PeRectLight()
{
	return std::make_shared<CS_PeRectLight>();
}
