#include "CS_MrGAni.h"
#include "CS_PeZzz.h"
#include "CS_PeSmoke.h"

CS_MrGAni::CS_MrGAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	cbRect.ignoreMovePlatform = true;
	drawAfterPlayer = true;
	ani.hideLayerList.insert(1);
}

void CS_MrGAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	Entity::Init(self);
}

void CS_MrGAni::Step()
{
	if (bDefeated)
	{
		auto& ani_no = ani.image_index;
		switch (act_no)
		{
		case 0:
			act_no = 1;
			ani_no = 9;
			vy = -0x200 / ts;
			vx = lr == 0 ? -0x100 / ts : 0x100 / ts;
			gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
			break;
		case 1:
			if (cbRect.cbBottom)
			{
				ani_no = 10;
				ani_wait = 0;
				act_no = 2;
				act_wait = 0;
			}
			break;
		case 2:
			vx = 8 * vx / 9;
			if (++ani_wait > 3)
			{
				ani_wait = 0;
				++ani_no;
			}
			if (ani_no > 11)
				ani_no = 10;
			if (++act_wait > 50)
			{
				gameFunc->PlaySound(L"CS_071_little_crash");
				//
				SetCS_PeSmokeMedium(shared_from_this(), x, y);
				Destroy();
			}
			break;
		}
		vy += 0x20 / ts;
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
	}
	else
	{
		//ƶƽ̨
		Entity::BeginMovingPlatform();
		stateGravity.Step();
		switch (stateID)
		{
		case 0://վ
			//գ
			if (Random(0, 120) == 10)
			{
				wink_counter = 8;
			}
			if (wink_counter > 0)
			{
				wink_counter--;
				ani.image_index = 1;
			}
			else
			{
				ani.image_index = 0;
			}
			stateGravity.Step();
			break;
		case 1://·
			stateGravity.Step();
			break;
		case 2://ڴ
			break;
		case 3://ڴ
			break;
		case 4://˯ڴϣzzz
			//zzz
			if (++act_wait > 100)
			{
				act_wait = 0;
				SetPeCS_Zzz(shared_from_this(), x, y);
			}
			break;
		case 5://ˤ´
			if (bSetSound && cbRect.cbBottom)
			{
				bSetSound = false;
				gameFunc->PlaySound(L"CS_071_little_crash");
				SetCS_PeSmokeMedium(shared_from_this(), x, y);
			}
			stateGravity.Step();
			break;
		case 6://
			break;
		case 7://
			if (lr == 0)
			{
				vx -= 0x10 / ts;
			}
			else
			{
				vx += 0x10 / ts;
			}
			if (vx > 0x400 / ts)
				vx = 0x400 / ts;
			if (vx < -0x400 / ts)
				vx = -0x400 / ts;
			break;
		}
		//ƶƽ̨
		Entity::EndMovingPlatform();
	}
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_MrGAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_gaudi_stand_l" : L"mc_gaudi_stand_r";
		break;
	case 1://·
		{
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			ani.sprite_index = lr == 0 ? L"mc_gaudi_move_l" : L"mc_gaudi_move_r";
		}
		break;
	case 2://ڴ
		vx = 0;
		y -= 6;
		ani.sprite_index = lr == 0 ? L"mc_gaudi_sit_l" : L"mc_gaudi_sit_r";
		break;
	case 3://ڴ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_gaudi_lie_l" : L"mc_gaudi_lie_r";
		break;
	case 4://˯ڴϣzzz
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_gaudi_lie_l" : L"mc_gaudi_lie_r";
		break;
	case 5://ˤ´
		bSetSound = true;
		break;
	case 6://
		gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
		ani.sprite_index = lr == 0 ? L"mc_gaudi_struggle_l" : L"mc_gaudi_struggle_r";
		break;
	case 7://
		ani.sprite_index = lr == 0 ? L"mc_gaudi_run_l" : L"mc_gaudi_run_r";
		break;
	case 8://
		act_no = 0;
		bDefeated = true;
		ani.sprite_index = lr == 0 ? L"ls_gaudi_l" : L"ls_gaudi_r";
		break;
	}
}

void CS_MrGAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"sit_on_bed")
		SetState(2, lr);
	else if (stateName == L"lie_on_bed")
		SetState(3, lr);
	else if (stateName == L"sleep_on_bed")
		SetState(4, lr);
	else if (stateName == L"fall_on_bed")
		SetState(5, lr);
	else if (stateName == L"struggle")
		SetState(6, lr);
	else if (stateName == L"run")
		SetState(7, lr);
	else if (stateName == L"jump")
		vy = -0x300 / ts;
	else if (stateName == L"defeated")
		SetState(8, lr);
}

std::shared_ptr<Entity> CreateCS_MrGAni()
{
	return std::make_shared<CS_MrGAni>();
}
