#include "CS_MiseryFloatingAni.h"

CS_MiseryFloatingAni::CS_MiseryFloatingAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
}

void CS_MiseryFloatingAni::Init(std::weak_ptr<Entity> self)
{
	stateTeleport.Init(self);
	Entity::Init(self);
}

void CS_MiseryFloatingAni::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		tgt_x = x;
		tgt_y = y;
		act_no = 10;
		[[fallthrough]];
	case 10:
		act_no = 11;
		act_wait = 0;
		ani_no = 0;
		vy = 0x200 / ts;
		[[fallthrough]];
	case 11:
		if (tgt_y < y)
			vy -= 0x10 / ts;
		if (tgt_y > y)
			vy += 0x10 / ts;
		if (vy > 0x100 / ts)
			vy = 0x100 / ts;
		if (vy < -0x100 / ts)
			vy = -0x100 / ts;
		break;
	case 13:
		ani_no = 1;
		vy += 0x40/ts;
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (cbRect.cbBottom)
		{
			gameFunc->PlaySound(L"CS_023_thud");
			vy = 0;
			act_no = 14;
			cbRect.enableSoild = false;
			ani_no = 2;
		}
		break;
	case 20:
		act_no = 21;
		ani_no = 0;
		vy = 0;
		cbRect.enableSoild = false;
		[[fallthrough]];
	case 21:
		vy -= 0x20 / ts;
		if (y < -0x1000 / ts)
			Destroy();
		break;
	case 25:
		act_no = 26;
		act_wait = 0;
		ani_no = 5;
		ani_wait = 0;
		[[fallthrough]];
	case 26:
		if (++ani_no > 7)
			ani_no = 5;
		if (++act_wait == 30)
		{
			gameFunc->PlaySound(L"CS_101_lightning_strike");
			gameFunc->SetScreenFlash(gameFunc->gameFlash, 20);
			act_no = 27;
			ani_no = 7;
		}
		break;
	case 27:
		if (++act_wait == 50)
			act_no = 14;
		break;
	case 50:
		ani.sprite_index = lr == 0 ? L"mc_misery_charge_l" : L"mc_misery_charge_r";
		return;
	case 60://
		stateTeleport.Step();
		break;
	}
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (act_no == 11)
	{
		if (ani_wait)
		{
			--ani_wait;
			ani_no = 1;
		}
		else
		{
			if (Random(0, 100) == 1)
				ani_wait = 30;

			ani_no = 0;
		}
	}

	if (act_no == 14)
	{
		if (ani_wait)
		{
			--ani_wait;
			ani_no = 3;
		}
		else
		{
			if (Random(0, 100) == 1)
				ani_wait = 30;

			ani_no = 2;
		}
	}
	ani.sprite_index = lr == 0 ? L"mc_misery_floating_l" : L"mc_misery_floating_r";
}

void CS_MiseryFloatingAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	act_no = stateID;
	ani.sprite_index = lr == 0 ? L"mc_misery_floating_l" : L"mc_misery_floating_r";
}

void CS_MiseryFloatingAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	if (stateName == L"charge")
		SetState(50, lr);
	if (stateName == L"teleport_in")
	{
		stateTeleport.SetTeleportIn();
		SetState(60, lr);
	}
}

std::shared_ptr<Entity> CreateCS_MiseryFloatingAni()
{
	return std::make_shared<CS_MiseryFloatingAni>();
}
