#include "CS_MagicThunder.h"
#include <algorithm>

void CS_MagicThunder::Step()
{
    auto wfrom = from.lock();
    if (!wfrom)
        return;
    auto wtarget = target.lock();
    if (!wtarget)
        return;
    last_x = x;
    last_y = y;
    x = wfrom->x;
    y = wfrom->y;
    CS_MagicThunder::Point start(from_dx, from_dy);
    CS_MagicThunder::Point end(wtarget->x - x + target_dx, wtarget->y - y + target_dy);
    // ɲ5߶ε
    GeneratePolyline(start, end, 20);
    DrawPolyline();
}

void CS_MagicThunder::SetState(int stateID, int lr)
{
    if (bSetFromDxDy)
    {
        bSetFromDxDy = false;
        from_dx = (float)stateID;
        from_dy = (float)lr;
    }
    else if (bSetTargetDxDy)
    {
        bSetTargetDxDy = false;
        target_dx = (float)stateID;
        target_dy = (float)lr;
    }
}

void CS_MagicThunder::SetState(std::wstring stateName, int lr)
{
    if (bSetFrom)
    {
        bSetFrom = false;
        from = GetEntityByEventName(stateName);
    }
    else if (bSetTarget)
    {
        bSetTarget = false;
        target = GetEntityByEventName(stateName);
    }
    else if (stateName == L"set_from")
        bSetFrom = true;
    else if (stateName == L"set_target")
        bSetTarget = true;
    else if (stateName == L"set_from_dxdy")
        bSetFromDxDy = true;
    else if (stateName == L"set_target_dxdy")
        bSetTargetDxDy = true;
}

std::weak_ptr<Entity> CS_MagicThunder::GetEntityByEventName(std::wstring eventName)
{
    std::shared_ptr<Entity> wtarget;
    auto& allRes = *gameFunc->GetLoadedEntity(gameFunc->entityRes);
    EntityLayer* eLayer = nullptr;
    for (auto& res : allRes)
    {
        if (res.first->layerType == 0)
        {
            eLayer = &res.second;
            break;
        }
    }
    if (eLayer)
    {
        bool bFound = false;
        //ȫʵѰ
        auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
        for (auto& p : allPlayer)
        {
            auto wplayer = p.second.lock();
            if (wplayer && wplayer->el.name == eventName)
            {
                wtarget = wplayer;
                bFound = true;
                break;
            }
        }
        //ڵͼʵѰ
        if (!bFound)
        {
            for (auto& e : eLayer->Ls)
            {
                if (e->el.eventName == eventName)
                {
                    wtarget = e;
                    break;
                }
            }
        }
    }
    if (wtarget)
    {
        return wtarget;
    }
    return std::weak_ptr<Entity>();
}

// 
void CS_MagicThunder::GeneratePolyline(CS_MagicThunder::Point start, CS_MagicThunder::Point end, int segments)
{
    polyline.clear();
    polyline.push_back(start);

    float dx = (end.x - start.x) / segments;
    float dy = (end.y - start.y) / segments;

    for (int i = 1; i < segments; ++i)
    {
        // ֱ·ƫ
        float offsetX = (std::rand() % 100) / 100.0f - 0.5f;
        float offsetY = (std::rand() % 100) / 100.0f - 0.5f;

        CS_MagicThunder::Point p;
        p.x = start.x + i * dx + offsetX * 16;
        p.y = start.y + i * dy + offsetY * 16;
        polyline.push_back(p);
    }
    polyline.push_back(end);
}

// 
void CS_MagicThunder::DrawPolyline()
{
    if (polyline.size() < 2)
        return;
    fillList.clear();
    int index = 0;
    DWORD c = lr == 0 ? RGBA(0xff, 0xff, 0xff, 0xff) : RGBA(0xf8, 0x4b, 0xff, 0xff);
    for (size_t i = 0; i < polyline.size() - 1; ++i)
        index += AddFillLine(fillList, index, polyline[i].x, polyline[i].y, c, polyline[i + 1].x, polyline[i + 1].y, c, 2);
}

std::shared_ptr<Entity> CreateCS_MagicThunder()
{
    return std::make_shared<CS_MagicThunder>();
}

