#include "CS_LightningStrike.h"
#include "CS_PeSmoke.h"

CS_LightningStrike::CS_LightningStrike()
{
	type = 2;
	//ײ
	cbRect.left = cbRect.right = 8;
	cbRect.bottom = 8;
	cbRect.top = 232;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_lightningstrike";
	noDir = true;
}

void CS_LightningStrike::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		if (lr != 0)
		{
			if (gameFunc->SetScreenFlash)
				gameFunc->SetScreenFlash(gameFunc->gameFlash, 20);
		}
		[[fallthrough]];
	case 1:
		if (++act_wait > 10)
		{
			act_no = 2;
			gameFunc->PlaySound(L"CS_101_lightning_strike");
		}
		break;
	case 2:
		if (++ani_wait > 2)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no == 2)
			damage = 10;
		if (ani_no > 4)
		{
			SetCS_PeSmokeMedium(shared_from_this(), x, y);
			Destroy();
		}
		break;
	}
}

void CS_LightningStrike::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = damage;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

std::shared_ptr<Entity> CreateCS_LightningStrike()
{
	return std::make_shared<CS_LightningStrike>();
}
