#include "CS_LavaDropBase.h"
#include "CS_LavaDrop.h"

CS_LavaDropBase::CS_LavaDropBase()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_lavadrop_generator";
}

void CS_LavaDropBase::Step()
{
	//ִ˶
	Entity::Step();
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		tgt_x = x;
		act_wait = interval;
		[[fallthrough]];
	case 1:
		ani_no = 0;
		if (act_wait)
		{
			--act_wait;
			return;
		}
		act_no = 10;
		ani_wait = 0;
		break;
	case 10:
		if (++ani_wait > 10)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 3)
		{
			ani_no = 0;
			act_no = 1;
			act_wait = interval;
			auto e = CreateCS_LavaDrop();
			e->x = x;
			e->y = y;
			gameFunc->SetEntity(shared_from_this(), e);
		}
		break;
	}
	if (ani_wait / 2 % 2)
		x = tgt_x;
	else
		x = tgt_x + 1;
}

void CS_LavaDropBase::SetState(int stateID, int lr)
{
	if (el.arg.length() && ParseInts(el.arg.c_str(), argbuff))
	{
		if (argbuff.size() >= 0)
		{
			interval = argbuff[0];
			el.arg.clear();
		}
	}
}

std::shared_ptr<Entity> CreateCS_LavaDropBase()
{
	return std::make_shared<CS_LavaDropBase>();
}
