#include "CS_KingLifeUp.h"
#include "CS_King.h"
#include "PeLifeRecover.h"
const int CS_KingSTATENAME_LIFEUP = GetNextEntityStateID();
CS_KingLifeUp::CS_KingLifeUp()
{
	stateID = CS_KingSTATENAME_LIFEUP;
	cd_counter = 0;
	cd_counter_max = 30;
	iconIndex = 3;
	mp_cost = 1;
	ani_counter = 7;
	recover_counter_max = 60;
}

const wchar_t* CS_KingLifeUp::GetSaveName()
{
	return L"LifeUp";
}

const wchar_t* CS_KingLifeUp::GetFuncName()
{
	return L"KingSkill_LifeUp";
}

const wchar_t* CS_KingLifeUp::GetCheckFuncName()
{
	return L"KingSkill_LifeUp_Check";
}

void CS_KingLifeUp::State()
{
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_King>(we);
	if (ani_counter > 0)
	{
		ani_counter--;
		if (ani_counter == 0)
			mychar->ani.sprite_index = we->lr == 0 ? L"mc_king_meditation_l" : L"mc_king_meditation_r";
	}
	//ſ˼ܼ
	if (!(mychar->input.key & keyMask) || !mychar->cbRect.cbBottom)
	{
		//ֱӻָվ
		mychar->action_timecounter = 0;
	}
	//ħֵת
	if (recover_counter > 0)
	{
		recover_counter--;
		if (recover_counter == 0)
		{
			recover_counter = recover_counter_max;
			mychar->mp -= max(1, (int)ceilf(mychar->mp_max / 10.0f));
			if (mychar->mp < 0)
				mychar->mp = 0;
			//ָ10%
			int val = max(1, (int)ceilf(mychar->hp_max / 10.0f));
			mychar->hp += val;
			if (mychar->hp > mychar->hp_max)
				mychar->hp = mychar->hp_max;
			//mpΪ㣬˳
			if (mychar->mp == 0 || mychar->hp == mychar->hp_max)
			{
				//ֱӻָվ
				mychar->action_timecounter = 0;
				//סüܼ
				mychar->inputLock.key |= keyMask;
			}
			we->gameFunc->SetDmgNum(we->gameFunc->dmgNum, val, we->x, we->y, 2, we);
			we->gameFunc->PlaySound(L"CS_020_health_refill");
		}
	}
}

void CS_KingLifeUp::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_King>(we);
	bUIShowDisableSkill = !(
		mychar->mp >= mp_cost &&
		mychar->hp < mychar->hp_max &&
		mychar->cbRect.cbBottom &&
		!lock
		);
	bool a1 = mychar->hp < mychar->hp_max &&
		mychar->cbRect.cbBottom &&
		!lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	if (a && b && c)
	{
		mychar->faceToBack = false;
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	if (!GetEnable())
	{
		//ζ
		if (a && b && !c)
		{
			we->shock_counter = 30;
			//ס
			mychar->inputLock.key |= keyMask;
		}
		//ȴʱ
		if (cd_counter > 0)
			cd_counter--;
	}
	EntitySkillState::SubStep();
}

void CS_KingLifeUp::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		//ʼ
		auto we = e.lock();
		if (!we)
			return;
		auto mychar = std::static_pointer_cast<CS_King>(we);
		enable = true;
		//
		cd_counter = cd_counter_max;
		mychar->action_timecounter = mychar->action_timecounter_max;
		//ʼ
		ani_counter = 6;
		mychar->ani.sprite_index = we->lr == 0 ? L"mc_king_to_meditation_l" : L"mc_king_to_meditation_r";
		//ָЧ
		auto pe = std::make_shared<PeLifeRecover>(mychar, &CS_KingLifeUp::LifeRecover_Leave, 0, 8);
		we->gameFunc->SetEntity(we, pe);
		//ʼָʱ
		recover_counter = recover_counter_max;
	}
	else
		enable = false;
}

bool CS_KingLifeUp::LifeRecover_Leave(std::weak_ptr<Entity> e)
{
	//ʼ
	auto we = e.lock();
	if (!we)
		return false;
	auto mychar = std::static_pointer_cast<CS_King>(we);
	return !mychar->skillLifeUp.GetEnable();
}
