#include "CS_KingGuardCircle.h"
#include "CS_King.h"
CS_KingGuardCircle::CS_KingGuardCircle(std::shared_ptr<Entity> parent)
{
	type = 3;
	attackParent = parent;
	topDraw = true;
	auto mychar = std::static_pointer_cast<CS_King>(parent);
	shieldHP_max = mychar->skillGuard.shieldHP;
	targetR = shieldR;
}

void CS_KingGuardCircle::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	auto mychar = std::static_pointer_cast<CS_King>(wattackParent);
	x = mychar->x;
	y = mychar->y;
	last_x = mychar->last_x;
	last_y = mychar->last_y;
	if (!leave)
		lr = mychar->lr;
	if (mychar->skillGuard.shieldHP < shieldHP_max)
		attacked = true;
	last_r = r;
	if (attacked)
		r = shieldR * mychar->skillGuard.shieldHP / shieldHP_max;
	else
		r += (targetR - r) / 5.0f;
	if (leave)
	{
		if (alpha > 0)
		{
			alpha -= 0.05f;
			if (alpha <= 0)
				inUsing = false;
		}
	}
	else
	{
		leave = !mychar->InAction() ||
			mychar->lastSkill != &mychar->skillGuard ||
			mychar->skillGuard.shieldHP <= 0;
	}
}

void CS_KingGuardCircle::DeltaTime(float deltaTime)
{
	float nowR = lerp(last_r, r, deltaTime);
	DWORD frontC = RGBA(0xff, 0xff, 0xff, (BYTE)(0xff * alpha * 1.0f));
	DWORD backC = RGBA(0xff, 0xff, 0xff, (BYTE)(0xff * alpha * 0.5f));
	if (lr == 0)
	{
		int lineIndex = 0;
		lineIndex += AddArc(lineList, lineIndex, nowR, -90, 90, backC, backC);
		lineIndex += AddArc(lineList, lineIndex, nowR, 90, 270, frontC, frontC);
	}
	else
	{
		int lineIndex = 0;
		lineIndex += AddArc(lineList, lineIndex, nowR, -90, 90, frontC, frontC);
		lineIndex += AddArc(lineList, lineIndex, nowR, 90, 270, backC, backC);
	}
	Entity::DeltaTime(deltaTime);
}
