#include "CS_KingAir.h"
#include "CS_King.h"
const int CS_KingSTATENAME_AIR = GetNextEntityStateID();
CS_KingAir::CS_KingAir()
{
	stateID = CS_KingSTATENAME_AIR;
}

void CS_KingAir::SetAir(int index)
{
	auto we = e.lock();
	if (!we)
		return;
	//ö
	const wchar_t* jump = L"";
	if (we->ud == -1)
		jump = we->lr == 0 ? L"mc_king_jump_lu" : L"mc_king_jump_ru";
	else if (we->ud == 0)
		jump = we->lr == 0 ? L"mc_king_jump_l" : L"mc_king_jump_r";
	else if (we->ud == 1)
		jump = we->lr == 0 ? L"mc_king_jump_ld" : L"mc_king_jump_rd";
	we->ani.sprite_index = jump;
	we->ani.image_index = index;
}

void CS_KingAir::State()
{
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_King>(we);
	auto& swimJump_counter = mychar->stateJump.swimJump_counter;
	if (swimJump_counter == 0)
	{
		if (we->vy < 0)
			SetAir(0);
		else
			SetAir(1);
	}
	else
	{
		if (we->vy < 0)
			SetAir(1);
		else
			SetAir(0);
	}
}

void CS_KingAir::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
		enable = true;
	else
		enable = false;
}
