#include "CS_Key.h"

CS_Key::CS_Key()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_key";
	cbRect.left = cbRect.right = 5;
	cbRect.top = cbRect.bottom = 6;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.fullWaterBlock = true;
	drawBeforeOtherEntity = true;
	hp = 1;
	//Ѷ
	caughtDifficulty = 0.5f;
}

void CS_Key::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Key::Step()
{
	stateGravity.SetPhysice(cbRect.inWater);
	stateResist.SetPhysice(cbRect.inWater);
	if (bCaught)
	{
		vx = vy = 0;
	}
	else
	{
		//ڵϵ
		stateGravity.Step();
	}
	if (cbRect.inWater)
		drawBeforeOtherEntity = false;
	else
		drawBeforeOtherEntity = true;
	if (flee_counter > 0)
		flee_counter--;
	if (cbRect.cbBottom)
		stateResist.Step();
	stateSplash.Step();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

std::weak_ptr<Entity> CS_Key::BeginCaught(std::weak_ptr<Entity> e)
{
	if (flee_counter > 0)
		return std::weak_ptr<Entity>();
	bCaught = true;
	return shared_from_this();
}

void CS_Key::EndCaught(std::weak_ptr<Entity> e)
{
	bCaught = false;
	if (cbRect.inWater)
	{
		//ĴӴ
		flee_counter = 120;
		//ƷԾ
		vy += Random(-0x600, -0x200) / ts;
		vx += Random(-0x300, 0x300) / ts;
	}
}

std::shared_ptr<Entity> CreateCS_Key()
{
	return std::make_shared<CS_Key>();
}
