#include "CS_KazumaAni.h"

CS_KazumaAni::CS_KazumaAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_KazumaAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	Entity::Init(self);
}

void CS_KazumaAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	switch (stateID)
	{
	case 0:
	case 1:
	case 2:
		stateGravity.Step();
		break;
	case 3://
		{
			auto& ani_no = ani.image_index;
			switch (act_no)
			{
			case 0:
				act_no = 1;
				ani_no = 0;
				ani_wait = 0;
				[[fallthrough]];
			case 1:
				if (++ani_wait > 2)
				{
					ani_wait = 0;
					++ani_no;
				}
				if (ani_no > 1)
					ani_no = 0;
				if (Random(0, 80) == 1)
				{
					act_no = 2;
					act_wait = 0;
					ani_no = 1;
				}
				if (Random(0, 120) == 10)
				{
					act_no = 3;
					act_wait = 0;
					ani_no = 2;
				}
				break;
			case 2:
				if (++act_wait > 40)
				{
					act_no = 3;
					act_wait = 0;
					ani_no = 2;
				}
				break;
			case 3:
				if (++act_wait > 80)
				{
					act_no = 1;
					ani_no = 0;
				}
				break;
			}
		}
		break;
	case 4:
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_KazumaAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_kazuma_stand_l" : L"mc_kazuma_stand_r";
		break;
	case 1://·
		{
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			ani.sprite_index = lr == 0 ? L"mc_kazuma_move_l" : L"mc_kazuma_move_r";
		}
		break;
	case 2://
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_kazuma_back_l" : L"mc_kazuma_back_r";
		break;
	case 3://
		act_no = 0;
		vx = 0;
		ani.sprite_index = L"mc_kazuma_computer";
		break;
	case 4://
		ani.sprite_index = lr == 0 ? L"mc_kazuma_dance_l" : L"mc_kazuma_dance_r";
		break;
	}
}

void CS_KazumaAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"computer")
		SetState(3, lr);
	else if (stateName == L"dance")
		SetState(4, lr);
}

std::shared_ptr<Entity> CreateCS_KazumaAni()
{
	return std::make_shared<CS_KazumaAni>();
}
