#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "CS_QuoteGravity.h"
#include "CS_JackFishWater.h"
#include "CS_JackFishControl.h"
#include "CS_JackFishResist.h"
#include "CS_JackFishJump.h"
#include "CS_JackFishStand.h"
#include "CS_JackFishSwim.h"
#include "CS_JackFishFaceToBack.h"
#include "CS_JackFishHurt.h"
#include "CS_JackFishBubbleBeam.h"
#define CS_JACKFISH_CREATENAME L"CS_mychar_jackfish"
//ҽɫ ܿˣ̬
class CS_JackFish :
    public MyCharEntity
{
public:
    CS_JackFish();
    void Init(std::weak_ptr<Entity> self) override;
    void Step() override;
    void SetState(int stateID, int lr) override;
    void SetState(std::wstring stateName, int lr) override;
	void LoadSaveData() override;//ر
	void WriteSaveData() override;//д뱣
	bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
	void Gain(std::weak_ptr<Entity> item) override;
	void Destroy() override;
	void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
	void CrushDeath();
	void CopyFrom(std::shared_ptr<Entity>& another) override;//ԼһԼͬʵһģһ
	//ͼʾ
	float animation_moveSpeed = 0x200 / ts;
	bool animation_delay = false;//·ӳһ֡뵽
	float floatSrcX = 0;//λ
	float floatSrcY = 0;
	//״̬ģ
	EntityStateFlashEffect stateFlash;
	EntityStateInvincible stateInvincible;
	CS_QuoteGravity stateGravity;
	CS_JackFishWater stateWater;
	CS_JackFishControl stateControl;
	CS_JackFishResist stateResist;
	CS_JackFishJump stateJump;
	CS_JackFishStand stateStand;
	CS_JackFishSwim stateSwim;
	CS_JackFishFaceToBack stateFaceToBack;
	CS_JackFishHurt stateHurt;
	//ģ
	CS_JackFishBubbleBeam skillBubbleBeam;
	//
	std::wstring crushEvent;
};

std::shared_ptr<Entity> CreateCS_JackFish();