#include "CS_JackCatcherBlade.h"
#include "CS_PeGunShotSpark.h"
#include "CS_PePhoton.h"
#include "CS_JackCatcherBubble.h"
#include "CS_PeBubbleBrust.h"
#include "CS_PeGunShotHit.h"
CS_JackCatcherBlade::CS_JackCatcherBlade(std::shared_ptr<Entity> parent, int level)
{
	type = 2;
	attackParent = parent;
	this->level = level;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	//õȼӦĸ
	SetLevel(level);
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 4;
		else
			x = parent->x + 4;
		y = parent->y - 12;
		SetCS_PeGunShotSpark(parent, x, y);
		x = parent->x;//
		vx = 0;
		vy = -moveSpeed;
	}
	else if (ud == 0)
	{
		y = parent->y;
		if (lr == 0)
		{
			x = parent->x - 12;
			SetCS_PeGunShotSpark(parent, x, y);
			x = parent->x - 7;//
			vx = -moveSpeed;
		}
		else
		{
			x = parent->x + 12;
			SetCS_PeGunShotSpark(parent, x, y);
			x = parent->x + 7;//
			vx = moveSpeed;
		}
		vy = 0;
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 10;
		SetCS_PeGunShotSpark(parent, x, y);
		x = parent->x;//
		vx = 0;
		vy = moveSpeed;
	}
	//Ч
	parent->gameFunc->PlaySound(L"CS_048_bubbler");
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	SetCbRect_Collision();
	hp_max = hp = 1;
}

void CS_JackCatcherBlade::Step()
{
	//ͼ
	if (ani.png.length() == 0)
	{
		ani.png = L"CS_CaveStoryMod";
	}
	if (level == 0)
	{
		vx /= 1.05f;
		vy /= 1.05f;
		if (abs(vx) < 0.001f)
			vx = 0;
		if (abs(vy) < 0.001f)
			vy = 0;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ǽײ
	SetCbRect_Collision();
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		if (level == 0)
		{
			SetCS_PePhoton(shared_from_this(), x, y);
		}
		else if (level == 1)
		{
			gameFunc->PlaySound(L"CS_028_shot_hit");
			SetCS_PeGunShotHit(shared_from_this(), x, y);
		}
		Destroy();
	}
	//ͼʧ
	if (IsOutOfMap(128))
		Destroy();
	//ʱ
	if (existTime > 0)
	{
		existTime--;
		if (existTime == 0)
		{
			if (level == 0)
				SetCS_PeBubbleBrust(shared_from_this(), x, y);
			else
				SetCS_PeGunShotHit(shared_from_this(), x, y);
			Destroy();
		}
	}
		
}

void CS_JackCatcherBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	auto wdst = dst.lock();
	if (!wdst)
		return;
	if (wdst->ignoreCaught)
		return;
	if (wdst->ignoreCaught_counter > 0)
		return;
	//
	auto wsrcTarget = wdst;
	bool bCaught = false;
	auto wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
	if (wcaughtTarget)
	{
		bCaught = true;
		while (wcaughtTarget != wsrcTarget)
		{
			wsrcTarget = wcaughtTarget;
			wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
			if (!wcaughtTarget)
			{
				wcaughtTarget = wsrcTarget;
				break;
			}
		}
	}
	else
	{
		//Ჶһ
		if (wsrcTarget->type == 0)
			return;
		wcaughtTarget = wsrcTarget;
	}
	if (wcaughtTarget->ignoreCaught)
		return;
	if (wcaughtTarget->ignoreCaught_counter > 0)
		return;
	if (wcaughtTarget)
	{
		//
		auto bubble = std::make_shared<CS_JackCatcherBubble>(wcaughtTarget, bCaught);
		gameFunc->SetEntity(shared_from_this(), bubble);
			wcaughtTarget->ignoreCaught_counter = INT_MAX;
	}
	Destroy();
}

bool CS_JackCatcherBlade::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	auto wsrc = src.lock();
	if (!wsrc)
		return false;
	if (wsrc->ignoreCaught)
		return false;
	if (wsrc->ignoreCaught_counter > 0)
		return false;

	int srcType = wsrc->type;
	auto wsrc_attackParent = wsrc->attackParent.lock();
	if (wsrc_attackParent)
		srcType = wsrc_attackParent->type;
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		//зӪ
		if (srcType == wattackParent->type)
			return false;
	}
	//
	auto wsrcTarget = wsrc;
	bool bCaught = false;
	auto wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
	if (wcaughtTarget)
	{
		while (wcaughtTarget != wsrcTarget)
		{
			wsrcTarget = wcaughtTarget;
			wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
			if (!wcaughtTarget)
			{
				wcaughtTarget = wsrcTarget;
				break;
			}
		}
	}
	else
	{
		//Ჶһ
		if (wsrcTarget->type == 0)
			return false;
		wcaughtTarget = wsrcTarget;
	}
	//Ŀ
	if (wcaughtTarget->ignoreCaught)
		return false;
	if (wcaughtTarget->ignoreCaught_counter > 0)
		return false;
	if (wcaughtTarget)
	{
		auto bubble = std::make_shared<CS_JackCatcherBubble>(wcaughtTarget, bCaught);
		gameFunc->SetEntity(shared_from_this(), bubble);
			wcaughtTarget->ignoreCaught_counter = INT_MAX;
	}
	Destroy();
	return false;
}

void CS_JackCatcherBlade::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void CS_JackCatcherBlade::SetLevel(int level)
{
	
	switch (level)
	{
	case 0:
		moveSpeed = 0x600 / ts;
		existTime = 100;
		ani.sprite_index = L"am_catcher_shoot1";
		break;
	case 1:
		moveSpeed = 0xa00 / ts;
		existTime = 60;
		ani.sprite_index = ud == 0 ? L"am_catcher_shoot2_lr" : L"am_catcher_shoot2_ud";
	}
}

void CS_JackCatcherBlade::SetCbRect_Entity()
{
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 6;
}

void CS_JackCatcherBlade::SetCbRect_Collision()
{
	cbRect.left = 3;
	cbRect.right = 3;
	cbRect.top = 3;
	cbRect.bottom = 3;
}
