#include "CS_JackBubblerBlade.h"
#include "CS_Jack.h"
#include "CS_PePhoton.h"
#include "CS_PeBubbleBrust.h"
#include "CS_PeGunShotSpark.h"
#include "CS_JackBubbleSpineBlade.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"
CS_JackBubblerBlade::CS_JackBubblerBlade(std::shared_ptr<Entity> parent, DWORD keyMask, int level)
{
	type = 2;
	attackParent = parent;
	this->keyMask = keyMask;
	this->level = level;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = 4;
	cbRect.right = 4;
	cbRect.top = 4;
	cbRect.bottom = 4;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 4;
		else
			x = parent->x + 4;
		y = parent->y - 8;
		SetCS_PeGunShotSpark(parent, x, y);
		x = parent->x;//
	}
	else if (ud == 0)
	{
		y = parent->y;
		if (lr == 0)
		{
			x = parent->x - 12;
			SetCS_PeGunShotSpark(parent, x, y);
			x = parent->x - 7;//
		}
		else
		{
			x = parent->x + 12;
			SetCS_PeGunShotSpark(parent, x, y);
			x = parent->x + 7;//
		}
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 8;
		SetCS_PeGunShotSpark(parent, x, y);
		x = parent->x;//
	}
	//Ч
	parent->gameFunc->PlaySound(L"CS_048_bubbler");
}

void CS_JackBubblerBlade::Step()
{
	GetPlayerVar();
	switch (level)
	{
	case 0:
		Level1Step();
		break;
	case 1:
		Level2Step();
		break;
	case 2:
		Level3Step();
		break;
	}
}

void CS_JackBubblerBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	switch (level)
	{
	default:
	case 0:
		*outDamage = 1;
		break;
	case 1:
		*outDamage = 2;
		break;
	case 2:
		*outDamage = 4;
		break;
	}
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 2;//ˮԹ
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_JackBubblerBlade::Feedback(std::weak_ptr<Entity> target)
{
	Destroy();
}

void CS_JackBubblerBlade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

void CS_JackBubblerBlade::Destroy()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return;

	auto mychar = std::static_pointer_cast<CS_Jack>(wattackParent);
	auto& amList = mychar->skillBubbler.amList;
	for (auto iter = amList.begin(); iter != amList.end(); iter++)
	{
		if ((*iter).lock() == shared_from_this())
		{
			amList.erase(iter);
			break;
		}
	}
	Entity::Destroy();
}

void CS_JackBubblerBlade::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void CS_JackBubblerBlade::Level1Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
	{
		ani.png = L"CS_CaveStoryMod";
		ani.sprite_index = L"am_bubbler1";
	}
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		if (ud == -1)
		{
			vx = 0;
			vy = -0x600 / ts;
		}
		else if (ud == 0)
		{
			if (lr == 0)
				vx = -0x600 / ts;
			else
				vx = 0x600 / ts;
			vy = 0;
		}
		else if (ud == 1)
		{
			vx = 0;
			vy = 0x600 / ts;
		}
		break;
	}
	if (ud == -1)
		vy += 42 / ts;
	else if (ud == 0)
	{
		if (lr == 0)
			vx += 42 / ts;
		else
			vx -= 42 / ts;
	}
	else if (ud == 1)
		vy -= 42 / ts;
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	if (++act_wait > 40)
	{
		Destroy();
		SetCS_PeBubbleBrust(shared_from_this(), x, y);
	}
	if (++ani_wait > 3)
	{
		ani_wait = 0;
		++ani_no;
	}
	if (ani_no > 3)
		ani_no = 3;
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		SetCS_PePhoton(shared_from_this(), x, y);
		Destroy();
	}
}

void CS_JackBubblerBlade::Level2Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
	{
		ani.png = L"CS_CaveStoryMod";
		ani.sprite_index = L"am_bubbler2";
	}
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		if (ud == -1)
		{
			vx = Random(-0x100, 0x100) / ts;
			vy = -0x600 / ts;
		}
		else if (ud == 0)
		{
			if (lr == 0)
				vx = -0x600 / ts;
			else
				vx = 0x600 / ts;
			vy = Random(-0x100, 0x100) / ts;
		}
		else if (ud == 1)
		{
			vx = Random(-0x100, 0x100) / ts;
			vy = 0x600 / ts;
		}
		break;
	}
	if (ud == -1)
		vy += 0x10 / ts;
	else if (ud == 0)
	{
		if (lr == 0)
			vx += 0x10 / ts;
		else
			vx -= 0x10 / ts;
	}
	else if (ud == 1)
		vy -= 0x10 / ts;
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	if (++act_wait > 60)
	{
		Destroy();
		SetCS_PeBubbleBrust(shared_from_this(), x, y);
	}
	if (++ani_wait > 3)
	{
		ani_wait = 0;
		++ani_no;
	}
	if (ani_no > 3)
		ani_no = 3;
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		SetCS_PePhoton(shared_from_this(), x, y);
		Destroy();
	}
}

void CS_JackBubblerBlade::Level3Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
	{
		ani.png = L"CS_CaveStoryMod";
		ani.sprite_index = L"am_bubbler3";
	}
	auto& ani_no = ani.image_index;
	bool bPressedKey = playerGameInput.key & keyMask;
	if (++act_wait > 100 || !bPressedKey)
	{
		Destroy();
		auto wattackParent = attackParent.lock();
		if (wattackParent)
		{
			auto am = std::make_shared<CS_JackBubbleSpineBlade>(wattackParent, x, y);
			gameFunc->SetEntity(wattackParent, am);
		}
	}
	else
	{
		switch (act_no)
		{
		case 0:
			act_no = 1;
			if (ud == -1)
			{
				vy = Random(-0x400, -0x200) / ts;
				vx = (Random(-4, 4) * 0x200) / 2 / ts;
			}
			else if (ud == 0)
			{
				if (lr == 0)
				{
					vx = Random(-0x400, -0x200) / ts;
					vy = Random(-0x400, -0x200) / ts;
				}
				else
				{
					vx = Random(0x200, 0x400) / ts;
					vy = Random(-0x400, -0x200) / ts;
				}
			}
			else if (ud == 1)
			{
				vy = Random(0x80, 0x100) / ts;
				vx = (Random(-4, 4) * 0x200) / 2 / ts;
			}
			break;
		}
		if (x < playerX)
			vx += 0x20 / ts;
		if (x > playerX)
			vx -= 0x20 / ts;
		if (y < playerY)
			vy += 0x20 / ts;
		if (y > playerY)
			vy -= 0x20 / ts;
		if (cbRect.cbLeft)
			vx = 0x400 / ts;
		if (cbRect.cbRight)
			vx = -0x400 / ts;
		if (cbRect.cbTop)
			vy = 0x400 / ts;
		if (cbRect.cbBottom)
			vy = -0x400 / ts;
		//ƶƽ̨
		Entity::EndMovingPlatform();
		//һײ
		Entity::ClearCollisionResult();
		//ִ˶
		Entity::Step();
		//ִײ
		Entity::Collision();
		if (++ani_wait > 3)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 3)
			ani_no = 3;
	}
}

void CS_JackBubblerBlade::GetPlayerVar()
{
	playerGameInput.key = 0;
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		playerGameInput = wattackParent->input;
		playerX = wattackParent->x;
		playerY = wattackParent->y;
	}
}
