#include "CS_Heart.h"

CS_Heart::CS_Heart()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.top = cbRect.right = cbRect.bottom = 6;
	isItem = true;
	el.name = CS_HEART_CREATENAME;
	hp = 2;
}

void CS_Heart::Step()
{
	auto& ani_no = ani.image_index;
	if (lr == 0)
	{
		if (++ani_wait > 2)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 1)
			ani_no = 0;
	}
	if (lFloat)
	{
		if (act_no == 0)
		{
			act_no = 1;
			vy = Random(-0x20, 0x20) / ts;
			vx = Random(0x7F, 0x100) / ts;
		}
		vx -= 8 / ts;
		if (x < -0x600 / ts)
			x = -0x600 / ts;
		if (cbRect.cbLeft)
			vx = 0x100 / ts;
		if (cbRect.cbTop)
			vy = 0x40 / ts;
		if (cbRect.cbBottom)
			vy = -0x40 / ts;
		//һײ
		Entity::ClearCollisionResult();
		//ִ˶
		Entity::Step();
		//ִײ
		Entity::Collision();
	}
	else if (rFloat)
	{
		if (act_no == 0)
		{
			act_no = 1;
			vy = Random(-0x20, 0x20) / ts;
			vx = Random(-0x100, -0x7F) / ts;
		}
		vx += 8 / ts;
		if (vx > 0x600 / ts)
			vx = 0x600 / ts;
		if (cbRect.cbRight)
			vx = -0x100 / ts;
		if (cbRect.cbTop)
			vy = 0x40 / ts;
		if (cbRect.cbBottom)
			vy = -0x40 / ts;
		//һײ
		Entity::ClearCollisionResult();
		//ִ˶
		Entity::Step();
		//ִײ
		Entity::Collision();
	}
	else
	{
		//ִ˶
		Entity::Step();
	}
	ani.sprite_index = largeSize ? L"ls_heart_large" : L"ls_heart_small";

	if (lr == 0)
		++count1;

	if (count1 > 550)
		Destroy();

	if (count1 > 500 && count1 / 2 % 2)
		ani.sprite_index.clear();

	if (count1 > 547)
		ani_no = 2;
}

bool CS_Heart::Item(std::weak_ptr<Entity> src)
{
	//ֻҲʰȡ
	auto wsrc = src.lock();
	if (!wsrc)
		return false;

	if (wsrc->type == 1)
		return true;
	else
		return false;
}

std::weak_ptr<Entity> CS_Heart::BeginCaught(std::weak_ptr<Entity> e)
{
	return shared_from_this();
}

void CS_Heart::EndCaught(std::weak_ptr<Entity> e)
{
}

void CS_Heart::SetLargeSize()
{
	largeSize = true;
	hp = 6;
}

void CS_Heart::SetLeftFloat()
{
	lFloat = true;
}

void CS_Heart::SetRightFloat()
{
	rFloat = true;
}

std::shared_ptr<Entity> CreateCS_Heart()
{
	return std::make_shared<CS_Heart>();
}

void SetHeartSmall(std::shared_ptr<Entity> parent, float x, float y)
{
	auto e = std::make_shared<CS_Heart>();
	e->x = x;
	e->y = y;
	parent->gameFunc->SetEntity(parent, e);
}

void SetHeartSmallLFloat(std::shared_ptr<Entity> parent, float x, float y)
{
	auto e = std::make_shared<CS_Heart>();
	e->x = x;
	e->y = y;
	e->lFloat = true;
	parent->gameFunc->SetEntity(parent, e);
}

void SetHeartSmallRFloat(std::shared_ptr<Entity> parent, float x, float y)
{
	auto e = std::make_shared<CS_Heart>();
	e->x = x;
	e->y = y;
	e->rFloat = true;
	parent->gameFunc->SetEntity(parent, e);
}

void SetHeartSmallStatic(std::shared_ptr<Entity> parent, float x, float y)
{
	auto e = std::make_shared<CS_Heart>();
	e->x = x;
	e->y = y;
	e->SetState(0, 1);
	parent->gameFunc->SetEntity(parent, e);
}

void SetHeartLarge(std::shared_ptr<Entity> parent, float x, float y)
{
	auto e = std::make_shared<CS_Heart>();
	e->x = x;
	e->y = y;
	e->SetLargeSize();
	parent->gameFunc->SetEntity(parent, e);
}

void SetHeartLargeLFloat(std::shared_ptr<Entity> parent, float x, float y)
{
	auto e = std::make_shared<CS_Heart>();
	e->x = x;
	e->y = y;
	e->SetLargeSize();
	e->SetLeftFloat();
	parent->gameFunc->SetEntity(parent, e);
}

void SetHeartLargeRFloat(std::shared_ptr<Entity> parent, float x, float y)
{
	auto e = std::make_shared<CS_Heart>();
	e->x = x;
	e->y = y;
	e->SetLargeSize();
	e->SetRightFloat();
	parent->gameFunc->SetEntity(parent, e);
}
