#include "CS_HealthRefillWater.h"

CS_HealthRefillWater::CS_HealthRefillWater()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_healthrefill_water";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	drawBeforeOtherEntity = true;
}

void CS_HealthRefillWater::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_HealthRefillWater::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

std::shared_ptr<Entity> CreateCS_HealthRefillWater()
{
	return std::make_shared<CS_HealthRefillWater>();
}
