#include "CS_Forcefield.h"

CS_Forcefield::CS_Forcefield()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_forcefield";
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	drawBeforeOtherEntity = true;
	cbRect.left = 5;
	cbRect.right = 5;
	cbRect.top = 8;
	cbRect.bottom = 8;
	noDir = true;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	isTrap = true;
	ignoreCaught = true;
}

void CS_Forcefield::Step()
{
	attackState = true;
}

bool CS_Forcefield::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	*outRealDamage = 0;
	return true;
}

void CS_Forcefield::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->ignoreTrap_counter > 0)
			return;
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outDamage = 1;
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x400 / ts;
	*outHeavy = 2;
}

void CS_Forcefield::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	auto wdst = target.lock();
	if (wdst)
	{
		if (realDamage > 0)
			wdst->ignoreTrap_counter = 180;
	}
}

std::shared_ptr<Entity> CreateCS_Forcefield()
{
	return std::make_shared<CS_Forcefield>();
}
