#include "CS_Enemy_TrackingBombSmall.h"
#include "CS_PeCountdown.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_TrackingBombSmall::CS_Enemy_TrackingBombSmall(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	ani.png = L"CS_CaveStoryMod";
	ani.hideLayerList.insert(0);
	cbRect.left = cbRect.right = 7;
	cbRect.top = 8;
	cbRect.bottom = 8;
	hp_max = hp = 20;
	dropExp = 5;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	ani.image_index = Random(0, 2);
}

void CS_Enemy_TrackingBombSmall::Step()
{
	if (birthTime > 0)
		birthTime--;
	if (bExplode)
	{
		Destroy();
		return;
	}
	switch (act_wait)
	{
	case 60 * 0:
		countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 5);
		break;
	case 60 * 1:
		countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 4);
		break;
	case 60 * 2:
		countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 3);
		break;
	case 60 * 3:
		countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 2);
		break;
	case 60 * 4:
		countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 1);
		break;
	case 60 * 5:
		damage = 20;
		attackState = true;
		damaged.clear();
		cbRect.left = cbRect.right = 64;
		cbRect.top = cbRect.bottom = 50;
		gameFunc->PlaySound(L"CS_035_explosion1");
		SetCS_PeSmoke(shared_from_this(), x, y, 25);
		bExplode = true;
		ani.png = L"";
		break;
	}
	++act_wait;
	//׷Ŀ
	auto wtarget = target.lock();
	if (wtarget)
	{
		const float speed = 0x200 / ts;
		lr = vx > 0 ? 1 : 0;
		float vec_x = wtarget->x - x;
		float vec_y = wtarget->y - y;
		auto vec = XMVector2Normalize(XMVectorSet(vec_x, vec_y, 0, 0));
		float dir_vx = XMVectorGetX(vec);
		float dir_vy = XMVectorGetY(vec);
		vx = dir_vx * speed;
		vy = dir_vy * speed;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	auto wcountdown = countdown.lock();
	if (wcountdown)
	{
		wcountdown->last_x = wcountdown->x;
		wcountdown->last_y = wcountdown->y;
		wcountdown->x = x + 8 + wcountdown->dx;
		wcountdown->y = y + 4 + wcountdown->dy;
	}
	ani.sprite_index = lr == 0 ? L"ls_counterbomb_small_l" : L"ls_counterbomb_small_r";
}

void CS_Enemy_TrackingBombSmall::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = damage;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_TrackingBombSmall::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (birthTime > 0)
		return false;
	if (getDamage == 0)
		return false;
	if (target.expired())
	{
		target = src;
		auto wsrc = src.lock();
		if (wsrc)
		{
			auto wattackParent = wsrc->attackParent.lock();
			if (wattackParent)
				target = wattackParent;
		}
	}
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_104");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void SetCS_Enemy_TrackingBombSmall(std::shared_ptr<Entity> parent, float x, float y, std::weak_ptr<Entity> target)
{
	auto am = std::make_shared<CS_Enemy_TrackingBombSmall>(parent);
	am->x = x;
	am->y = y;
	am->target = target;
	parent->gameFunc->SetEntity(parent, am);
}
