#pragma once
#include "Entity.h"
#include "EntityStateGravity.h"
#include "EntityStateSplash.h"
#define CS_ENEMY_STARFISH_CREATENAME L"CS_enemy_starfish"
//
class CS_Enemy_Starfish :
    public Entity
{
public:
    CS_Enemy_Starfish();
    void Init(std::weak_ptr<Entity> self) override;
    void Step() override;
    void SetState(int stateID, int lr) override;
    void Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy) override;
    bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
    void Dash(std::shared_ptr<Entity> target);
    EntityStateGravity stateGravity;
    EntityStateSplash stateSplash;
    int flash_counter = 0;
    int wink_counter = 0;
    float dashSpeed = 0x800 / ts;
    int dash_interval_counter = 0;
    int dash_interval_counter_max = 120;
};

std::shared_ptr<Entity> CreateCS_Enemy_Starfish();