#include "CS_Enemy_SoapFrontDmgRect.h"

CS_Enemy_SoapFrontDmgRect::CS_Enemy_SoapFrontDmgRect(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	cbRect.left = cbRect.right = 2;
	cbRect.top = cbRect.bottom = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_SoapFrontDmgRect::Step()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
		ignoreCaught_counter = wattackParent->ignoreCaught_counter;
}

std::weak_ptr<Entity> CS_Enemy_SoapFrontDmgRect::BeginCaught(std::weak_ptr<Entity> e)
{
	return attackParent;
}

void CS_Enemy_SoapFrontDmgRect::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = dmg;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}
