#include "CS_Enemy_SeaCucumber.h"
#include "CS_PeSmoke.h"
CS_Enemy_SeaCucumber::CS_Enemy_SeaCucumber()
{
	ani.png = L"CS_CaveStoryMod";
	cbRect.left = cbRect.right = 12;
	cbRect.top = 6;
	cbRect.bottom = 8;
	hp_max = hp = 12;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_SeaCucumber::Step()
{
	if (flash_counter > 0)
	{
		if (flash_counter / 2 % 2 == 0)
			ani.png = L"";
		else
			ani.png = L"CS_CaveStoryMod";
		flash_counter--;
	}
	else
		ani.png = L"CS_CaveStoryMod";
	if (hp > 0)
		ani.sprite_index = lr == 0 ? L"ls_seacucumber_stand_l" : L"ls_seacucumber_stand_r";
	else
		ani.sprite_index = lr == 0 ? L"ls_seacucumber_dead_l" : L"ls_seacucumber_dead_r";
}

void CS_Enemy_SeaCucumber::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_seacucumber_stand_l" : L"ls_seacucumber_stand_r";
}

bool CS_Enemy_SeaCucumber::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	if (hp <= 0)
		return false;
	*outRealDamage = getDamage;
	flash_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_sea_enemy_hurt0");
	}
	else
	{
		flash_counter = 0;
		gameFunc->PlaySound(L"CS_sea_destroy1"); 
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		hp = 0;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_SeaCucumber()
{
	return std::make_shared<CS_Enemy_SeaCucumber>();
}
