#include "CS_Enemy_OctopusBlade.h"

CS_Enemy_OctopusBlade::CS_Enemy_OctopusBlade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_octopus";
	//
	speedDir = true;
	action_timecounter = 180;
}

void CS_Enemy_OctopusBlade::Step()
{
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ǽײ
	SetCbRect_Collision();
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	if (bDisappear)
	{
		ani.sprite_index = L"pe_octopusshot_disappear";
		if (ani.image_index >= 3)
			Destroy();
	}
	else
	{
		//ǽʧ
		if (cbRect.enableSoild)
		{
			cbRect.enableSoild = false;
		}
		else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
		{
			bDisappear = true;
			ani.sprite_index = L"pe_octopusshot_disappear";
			ani.image_index = 0;
		}
		//ʧ
		if (action_timecounter > 0)
		{
			action_timecounter--;
			if (action_timecounter == 0)
			{
				bDisappear = true;
				ani.sprite_index = L"pe_octopusshot_disappear";
				ani.image_index = 0;
			}
		}
	}
}

void CS_Enemy_OctopusBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 4;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void CS_Enemy_OctopusBlade::Feedback(std::weak_ptr<Entity> target)
{
	bDisappear = true;
	ani.sprite_index = L"pe_octopusshot_disappear";
	ani.image_index = 0;
}

void CS_Enemy_OctopusBlade::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void CS_Enemy_OctopusBlade::SetCbRect_Entity()
{
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
}

void CS_Enemy_OctopusBlade::SetCbRect_Collision()
{
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 1;
}

void SetCS_Enemy_OctopusBlade(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_Enemy_OctopusBlade>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
