#include "CS_Enemy_GaudiFly.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmGaudiProjectile.h"
CS_Enemy_GaudiFly::CS_Enemy_GaudiFly()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 11;
	cbRect.bottom = 8;
	hp_max = hp = 15;
	dropExp = 8;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_GaudiFly::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_GaudiFly::Step()
{
	auto& ani_no = ani.image_index;
	stateSplash.Step();
	if (hp > 0)
	{
		switch (act_no)
		{
		case 0:
			{
				float radian = Random(0, 360) * deg2rad;
				vx = cosf(radian);
				tgt_x = x + 8 * cosf(radian + XM_PIDIV2);

				radian = Random(0, 360) * deg2rad;
				vy = sinf(radian);
				tgt_y = y + 8 * sinf(radian + XM_PIDIV2);
			}
			act_no = 1;
			count1 = 120;
			act_wait = Random(70, 150);
			ani_no = 14;
			[[fallthrough]];
		case 1:
			if (++ani_no > 15)
				ani_no = 14;
			if (act_wait)
			{
				--act_wait;
			}
			else
			{
				act_no = 2;
				ani_no = 18;
			}
			break;
		case 2:
			if (++ani_no > 19)
				ani_no = 18;
			if (++act_wait > 30)
			{
				if (gameFunc->GetPlayerDistanceWithLineTest)
				{
					auto wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						float dx = wplayer->x - x;
						float dy = wplayer->y - y;
						auto angle = XMConvertToDegrees(XMVectorGetX(XMVector2AngleBetweenVectors(XMVectorSet(1, 0, 0, 0), XMVectorSet(dx, dy, 0, 0))));
						if (dy < 0)
							angle = 360 - angle;
						angle += Random(-6, 6);
						float radian = angle * deg2rad;
						SetCS_AmGaudiProjectile(shared_from_this(), x, y, 3 * cosf(radian), 3 * sinf(radian));
						gameFunc->PlaySound(L"CS_039_em_fire");
					}
				}
				act_no = 1;
				act_wait = Random(70, 150);
				ani_no = 14;
				ani_wait = 0;
			}
			break;
		}
		if (gameFunc->GetPlayerDistanceWithLineTest)
		{
			auto wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				lr = wplayer->x < x ? 0 : 1;
			}
		}
		if (tgt_x < x)
			vx -= 0x10 / ts;
		if (tgt_x > x)
			vx += 0x10 / ts;
		if (tgt_y < y)
			vy -= 0x10 / ts;
		if (tgt_y > y)
			vy += 0x10 / ts;
	}
	else
	{
		switch (act_no)
		{
		case 0:
			act_no = 1;
			ani_no = 9;
			vy = -0x200 / ts;
			vx = lr == 0 ? -0x100 / ts : 0x100 / ts;
			gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
			break;
		case 1:
			if (cbRect.cbBottom)
			{
				ani_no = 10;
				ani_wait = 0;
				act_no = 2;
				act_wait = 0;
			}
			break;
		case 2:
			vx = 8 * vx / 9;
			if (++ani_wait > 3)
			{
				ani_wait = 0;
				++ani_no;
			}
			if (ani_no > 11)
				ani_no = 10;
			if (++act_wait > 50)
			{
				gameFunc->PlaySound(L"CS_071_little_crash");
				//
				SetCS_PeSmokeMedium(shared_from_this(), x, y);

				//Ʒ
				SetDropItem(shared_from_this(), x, y, dropExp);
				Destroy();
			}
			break;
		}
		vy += 0x20 / ts;
	}
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	ani.sprite_index = lr == 0 ? L"ls_gaudi_l" : L"ls_gaudi_r";
}

void CS_Enemy_GaudiFly::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_gaudi_l" : L"ls_gaudi_r";
	ani.image_index = 14;
}

void CS_Enemy_GaudiFly::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (hp <= 0)
		return;
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_GaudiFly::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (hp <= 0)
		return false;
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	if (hp <= 0)
	{
		act_no = 0;
		hp = 0;
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_GaudiFly()
{
	return std::make_shared<CS_Enemy_GaudiFly>();
}
