#include "CS_Enemy_FireWhirrr.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmFireWhirrr.h"
CS_Enemy_FireWhirrr::CS_Enemy_FireWhirrr()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	cbRect.left = cbRect.right = 4;
	cbRect.top = cbRect.bottom = 12;
	cbRect.waterBlock = true;
	hp_max = hp = 50;
	dropExp = 20;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_FireWhirrr::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		act_wait = Random(0, 50);
		tgt_y = y;
		[[fallthrough]];
	case 1:
		if (act_wait)
		{
			--act_wait;
		}
		else
		{
			act_no = 10;
			vy = 0x200 / ts;
		}
		[[fallthrough]];
	case 10:
		if (++ani_wait > 0)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 1)
			ani_no = 0;
		if (y < tgt_y)
			vy += 0x10 / ts;
		else
			vy -= 0x10 / ts;
		if (vy > 0x200 / ts)
			vy = 0x200 / ts;
		if (vy < -0x200 / ts)
			vy = -0x200 / ts;
		++count1;
		if (count1 > 20)
		{
			SetCS_AmFireWhirrr(shared_from_this(), x, y, 0, 0, bHorizontal);
			count1 = -100;
		}
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (bHorizontal)
		ani.sprite_index = lr == 0 ? L"ls_firewhirrr_d" : L"ls_firewhirrr_u";
	else
		ani.sprite_index = lr == 0 ? L"ls_firewhirrr_l" : L"ls_firewhirrr_r";
}

void CS_Enemy_FireWhirrr::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_firewhirrr_l" : L"ls_firewhirrr_r";
	if (el.arg == L"h")
	{
		bHorizontal = true;
		ani.sprite_index = lr == 0 ? L"ls_firewhirrr_d" : L"ls_firewhirrr_u";
		cbRect.left = cbRect.right = 12;
		cbRect.top = cbRect.bottom = 4;
	}
}

void CS_Enemy_FireWhirrr::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_FireWhirrr::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_FireWhirrr()
{
	return std::make_shared<CS_Enemy_FireWhirrr>();
}
