#include "CS_Enemy_CounterBombSmall.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_PeCountdown.h"

CS_Enemy_CounterBombSmall::CS_Enemy_CounterBombSmall()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.hideLayerList.insert(1);
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 7;
	cbRect.top = 8;
	cbRect.bottom = 8;
	hp_max = hp = 20;
	dropExp = 5;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	ani.image_index = Random(0, 2);
}

void CS_Enemy_CounterBombSmall::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(self);
	Entity::Init(self);
}

void CS_Enemy_CounterBombSmall::Step()
{
	if (birthTime > 0)
		birthTime--;
	stateGravity.Step();
	if (abs(vx) > 0.001f)
		vx /= 1.1f;
	else
		vx = 0;
	if (bExplode)
	{
		Destroy();
		return;
	}
	switch (act_no)
	{
	case 0:
		act_no = 1;
		count1 = 120;
		act_wait = Random(0, 50);
		[[fallthrough]];
	case 1:
		if (++act_wait < 50)
			break;
		act_wait = 0;
		act_no = 2;
		break;
	case 2:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (abs(wplayer->x - x) <= 50 && abs(wplayer->y - y) <= 40)
				{
					act_wait = 0;
					act_no = 3;
				}
			}
		}
		if (shock_counter > 0)
		{
			act_wait = 0;
			act_no = 3;
		}
		break;
	case 3:
		switch (act_wait)
		{
		case 60 * 0:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 5);
			break;
		case 60 * 1:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 4);
			break;
		case 60 * 2:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 3);
			break;
		case 60 * 3:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 2);
			break;
		case 60 * 4:
			countdown = SetCS_PeCountdown(shared_from_this(), x + 8, y + 4, 1);
			break;
		case 60 * 5:
			damage = 20;
			attackState = true;
			damaged.clear();
			cbRect.left = cbRect.right = 64;
			cbRect.top = cbRect.bottom = 50;
			gameFunc->PlaySound(L"CS_035_explosion1");
			SetCS_PeSmoke(shared_from_this(), x, y, 25);
			bExplode = true;
			ani.png = L"";
			break;
		}
		++act_wait;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	auto wcountdown = countdown.lock();
	if (wcountdown)
	{
		wcountdown->last_x = wcountdown->x;
		wcountdown->last_y = wcountdown->y;
		wcountdown->x = x + 8 + wcountdown->dx;
		wcountdown->y = y + 4 + wcountdown->dy;
	}
}

void CS_Enemy_CounterBombSmall::SetState(int stateID, int lr)
{
	this->lr = lr;
	act_no = stateID;
	ani.sprite_index = lr == 0 ? L"ls_counterbomb_small_l" : L"ls_counterbomb_small_r";
}

void CS_Enemy_CounterBombSmall::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = damage;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_CounterBombSmall::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (birthTime > 0)
		return false;
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_104");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_CounterBombSmall()
{
	return std::make_shared<CS_Enemy_CounterBombSmall>();
}
