#include "CS_Enemy_BuyoBuyoBase.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmBuyoBuyo.h"
#include "CS_AmBuyoBuyoBounce.h"
CS_Enemy_BuyoBuyoBase::CS_Enemy_BuyoBuyoBase()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.left = cbRect.right = 4;
	cbRect.top = cbRect.bottom = 12;
	hp_max = hp = 60;
	dropExp = 9;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_BuyoBuyoBase::Step()
{
	auto& ani_no = ani.image_index;
	if (act_no < 3 && hp <= 0)
	{
		act_no = 10;
		ani_no = 2;
	}
	switch (act_no)
	{
	case 0:
		act_no = 1;
		ani_no = 0;
		ani_wait = 0;
		[[fallthrough]];
	case 1:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (lr == 0)
				{
					if (x < wplayer->x + 160 && x > wplayer->x - 160 && y < wplayer->y + 160 && y > wplayer->y - 16)
						++count1;
				}
				else
				{
					if (x < wplayer->x + 160 && x > wplayer->x - 160 && y < wplayer->y + 16 && y > wplayer->y - 160)
						++count1;
				}
			}
		}
		if (count1 > 10)
		{
			act_no = 2;
			act_wait = 0;
		}
		break;
	case 2:
		if (++ani_wait > 3)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 1)
			ani_no = 0;
		if (++act_wait > 10)
		{
			if (++count2 > 2)
			{
				count2 = 0;
				count1 = -90;
			}
			else
			{
				count1 = -10;
			}
			if (Random(0, 1) == 0)
				SetCS_AmBuyoBuyo(shared_from_this(), x, y + (lr == 0 ? -8 : 8), 0, 0);
			else
				SetCS_AmBuyoBuyoBounce(shared_from_this(), x, y + (lr == 0 ? -8 : 8), 0, 0);
			gameFunc->PlaySound(L"CS_039_em_fire");
			act_no = 0;
			ani_no = 0;
		}
		break;
	}
	//ִ˶
	Entity::Step();
}

void CS_Enemy_BuyoBuyoBase::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_buyobuyobase_d" : L"ls_buyobuyobase_u";
}

void CS_Enemy_BuyoBuyoBase::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (hp > 0)
	{
		*outDamage = 1;
		auto wdst = dst.lock();
		if (wdst)
		{
			if (wdst->lr == 0)
			{
				*outAngle = 315;
			}
			else
			{
				*outAngle = 225;
			}
		}
		*outTakedown = true;
		*outElemType = 0;
		*outShockForce = 0x200 / ts;
		*outHeavy = 2;
	}
}

bool CS_Enemy_BuyoBuyoBase::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	if (hp <= 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_BuyoBuyoBase()
{
	return std::make_shared<CS_Enemy_BuyoBuyoBase>();
}
