#include "CS_Enemy_Bluefish.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_PeWaterDrop.h"
CS_Enemy_Bluefish::CS_Enemy_Bluefish()
{
	//Ѷ
	caughtDifficulty = 0.7f;
	swimModeChangeCounter = 1;
}

void CS_Enemy_Bluefish::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_bluefish_swim_l" : L"ls_bluefish_swim_r";
}

void CS_Enemy_Bluefish::HurtAnimate()
{
	ani.sprite_index = lr == 0 ? L"ls_bluefish_hurt_l" : L"ls_bluefish_hurt_r";
}

void CS_Enemy_Bluefish::AnimateSpeedStep()
{
	float sp = max(abs(vx), abs(vy));
	ani.image_counter_speed = sp * 2;
	if (ani.image_counter_speed < 0.1f)
		ani.image_index = 0;
}

void CS_Enemy_Bluefish::SwimStep()
{
	//Ӿ
	if (swimModeChangeCounter > 0)
	{
		swimModeChangeCounter--;
		if (swimModeChangeCounter == 0)
		{
			//ıӾ̬
			float speedX = Random(-0x600, 0x600) / ts;
			float speedY = Random(-0x300, 0x300) / ts;
			vx += speedX;
			vy += speedY;
			lr = vx < 0 ? 0 : 1;
			swimModeChangeCounter = Random(10, 120);
		}
	}
	ResistStep();
	if (lr == 0 && cbRect.cbLeft)
	{
		lr = 1;
		vx = Random(0, 0x600) / ts;
	}
	else if (lr == 1 && cbRect.cbRight)
	{
		lr = 0;
		vx = Random(-0x600, 0) / ts;
	}
	ani.sprite_index = lr == 0 ? L"ls_bluefish_swim_l" : L"ls_bluefish_swim_r";
}

std::shared_ptr<Entity> CreateCS_Enemy_Bluefish()
{
	return std::make_shared<CS_Enemy_Bluefish>();
}
