#include "CS_Enemy_Bee.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_Bee::CS_Enemy_Bee()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 6;
	hp_max = hp = 4;
	dropExp = 2;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	el.name = CS_ENEMY_BEE_CREATENAME;
}

void CS_Enemy_Bee::Step()
{
	auto& ani_no = ani.image_index;
	//׷
	if (gameFunc->GetPlayerDistance)
	{
		auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
		if (wplayer)
		{
			if (x > wplayer->x)
				lr = 0;
			else
				lr = 1;
			XMVECTOR dir = XMVector2Normalize(XMVectorSet(wplayer->x - x, wplayer->y - y, 0, 0));
			vx = XMVectorGetX(dir) * moveSpeed;
			vy = XMVectorGetY(dir) * moveSpeed;
		}
	}
	//˶
	if (vecArr.empty())
	{
		FillZeroSumVector(vecArr, 60);
	}
	else if(ani_no == 0)
	{
		auto& vec = vecArr.back();
		float vec_x = XMVectorGetX(vec);
		float vec_y = XMVectorGetY(vec);
		x += vec_x * moveSpeed * 2;
		y += vec_y * moveSpeed * 2;
		vecArr.pop_back();
	}
	if (++ani_wait > 1)
	{
		ani_wait = 0;
		++ani_no;
	}
	if (ani_no > 1)
		ani_no = 0;
	ani.sprite_index = lr == 0 ? L"ls_bee_l" : L"ls_bee_r";
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_Enemy_Bee::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_bee_l" : L"ls_bee_r";
}

void CS_Enemy_Bee::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Bee::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Bee()
{
	return std::make_shared<CS_Enemy_Bee>();
}
