#include "CS_CurlyStand.h"
#include "CS_Curly.h"
const int CS_CurlySTATENAME_STAND = GetNextEntityStateID();
CS_CurlyStand::CS_CurlyStand()
{
	stateID = CS_CurlySTATENAME_STAND;
}

void CS_CurlyStand::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	if (mychar->fishState)
	{
		const wchar_t* stand = L"";
		if (we->ud == -1)
			stand = we->lr == 0 ? L"mc_curlyfish_stand_lu" : L"mc_curlyfish_stand_ru";
		else if (we->ud == 0)
			stand = we->lr == 0 ? L"mc_curlyfish_stand_l" : L"mc_curlyfish_stand_r";
		else if (we->ud == 1)
			stand = we->lr == 0 ? L"mc_curlyfish_stand_ld" : L"mc_curlyfish_stand_rd";
		we->ani.sprite_index = stand;
	}
	else
	{
		const wchar_t* stand = L"";
		if (we->ud == -1)
			stand = we->lr == 0 ? L"mc_curly_stand_lu" : L"mc_curly_stand_ru";
		else
			stand = we->lr == 0 ? L"mc_curly_stand_l" : L"mc_curly_stand_r";
		we->ani.sprite_index = stand;
	}
	//գ
	if (Random(0, 120) == 10)
	{
		wink_counter = 8;
	}
	if (wink_counter > 0)
	{
		wink_counter--;
		we->ani.image_index = 1;
	}
	else
	{
		we->ani.image_index = 0;
	}
}

void CS_CurlyStand::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
		enable = true;
	else
		enable = false;
}
