#include "CS_CurlyEnergyShieldCircle.h"

CS_CurlyEnergyShieldCircle::CS_CurlyEnergyShieldCircle(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_energyshield";
	cbRect.left = 16;
	cbRect.right = 16;
	cbRect.top = 16;
	cbRect.bottom = 16;
	x = parent->x + dx;
	last_x = parent->last_x + dx;
	y = parent->y + dy;
	last_y = parent->last_y + dy;
}

void CS_CurlyEnergyShieldCircle::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	x = wattackParent->x + dx;
	last_x = wattackParent->last_x + dx;
	y = wattackParent->y + dy;
	last_y = wattackParent->last_y + dy;
	if (leave)
	{
		if (alpha > 0)
			alpha -= 0.05f;
		if (alpha < 0)
		{
			alpha = 0;
			Destroy();
		}
	}
	else
	{
		if (alpha < 1)
			alpha += 0.05f;
		if (alpha > 1)
			alpha = 1;
	}
	color = RGBA(0xff, 0xff, 0xff, (BYTE)(alpha * 0xff));
}

bool CS_CurlyEnergyShieldCircle::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	*outRealDamage = 0;
	return true;
}

void CS_CurlyEnergyShieldCircle::SetLeave()
{
	leave = true;
}
