#include "CS_Camera.h"

void CS_Camera::Step()
{
	switch (stateID)
	{
	case 0:
		vx = vy = 0;
		break;
	case 1://
		vy = -moveSpeed;
		break;
	case 2://
		vy = moveSpeed;
		break;
	case 3://
		vx = -moveSpeed;
		break;
	case 4://
		vx = moveSpeed;
		break;
	}
	//ִ˶
	Entity::Step();
}

void CS_Camera::SetState(int stateID, int lr)
{
	if (stateID != 0)
		moveSpeed = (float)stateID;
}

void CS_Camera::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal" || stateName == L"stop")
		stateID = 0;
	else if (stateName == L"up")
		stateID = 1;
	else if (stateName == L"down")
		stateID = 2;
	else if (stateName == L"left")
		stateID = 3;
	else if (stateName == L"right")
		stateID = 4;
	else if (stateName == L"set_speed")
		moveSpeed = (float)lr;
}

std::shared_ptr<Entity> CreateCS_Camera()
{
	return std::make_shared<CS_Camera>();
}
