#include "CS_Boss_SoapKingMagicFloor_Wall.h"

CS_Boss_SoapKingMagicFloor_Wall::CS_Boss_SoapKingMagicFloor_Wall(std::shared_ptr<Entity> parent, float x, float y, int dir, int count, int wallTime)
{
	attackParent = parent;
	this->x = x;
	this->y = y;
	setDir = dir;
	setCount = count;
	setWallTime = wallTime;

	setCount--;
	setInterval_count = setInterval_count_max;
}

void CS_Boss_SoapKingMagicFloor_Wall::Step()
{
	if (setInterval_count > 0)
	{
		setInterval_count--;
		if (setInterval_count == 0)
		{
			//÷
			auto wattackParent = attackParent.lock();
			if (wattackParent)
			{
				auto wfloor = SetCS_Boss_SoapKingMagicFloor(wattackParent, x, y).lock();
				ControlledFloor cf;
				cf.wallTime = setWallTime;
				cf.floor = wfloor;
				cfArr.push_back(cf);
				switch (setDir)
				{
				case 0:
					y -= wfloor->cbRect.bottom + wfloor->cbRect.top;
					break;
				case 1:
					x += wfloor->cbRect.left + wfloor->cbRect.right;
					break;
				case 2:
					y += wfloor->cbRect.bottom + wfloor->cbRect.top;
					break;
				case 3:
					x -= wfloor->cbRect.left + wfloor->cbRect.right;
					break;
				}
			}
			if (setCount > 0)
			{
				setCount--;
				setInterval_count = setInterval_count_max;
			}
		}
	}
	for (auto iter = cfArr.begin(); iter != cfArr.end(); iter++)
	{
		auto& cf = *iter;
		if (cf.wallTime > 0)
		{
			cf.wallTime--;
			if (cf.wallTime == 0)
			{
				//ùĿ
				auto wattackParent = attackParent.lock();
				if (wattackParent)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, wattackParent->x, wattackParent->y).lock();
					if (wplayer)
					{
						auto wfloor = cf.floor.lock();
						if (wfloor)
						{
							wfloor->ShootToTarget(wplayer);
							cfArr.erase(iter);
							break;
						}
					}
				}
			}
		}
	}
	if (setCount == 0 && cfArr.empty())
		Destroy();
}

void SetCS_Boss_SoapKingMagicFloor_Wall(std::shared_ptr<Entity> parent, float x, float y, int dir, int count, int wallTime)
{
	auto am = std::make_shared<CS_Boss_SoapKingMagicFloor_Wall>(parent, x, y, dir, count, wallTime);
	parent->gameFunc->SetEntity(parent, am);
}
