#include "CS_Boss_SoapKingMagicFloor_FloatFloor.h"

CS_Boss_SoapKingMagicFloor_FloatFloor::CS_Boss_SoapKingMagicFloor_FloatFloor(std::shared_ptr<Entity> parent, float x, float y)
{
	attackParent = parent;
	this->x = x;
	this->y = y;
	setCount = 4;
	floatCenterY = y;

	setCount--;
	setInterval_count = setInterval_count_max;
}

void CS_Boss_SoapKingMagicFloor_FloatFloor::SetFloatCenter(float centerY)
{
	floatCenterY = centerY;
}

void CS_Boss_SoapKingMagicFloor_FloatFloor::Step()
{
	if (setInterval_count > 0)
	{
		setInterval_count--;
		if (setInterval_count == 0)
		{
			//÷
			auto wattackParent = attackParent.lock();
			if (wattackParent)
			{
				auto wfloor = SetCS_Boss_SoapKingMagicFloor(wattackParent, x + (3 - setCount) * 16 + offsetX, y).lock();
				floorArr.push_back(wfloor);
			}
			if (setCount > 0)
			{
				setCount--;
				setInterval_count = setInterval_count_max;
			}
		}
	}
	//ҡ
	if (floatCenterY < y)
		vy -= 0x8 / ts;
	if (floatCenterY > y)
		vy += 0x8 / ts;
	//
	if (vy >= 0x200 / ts)
		vy = 0x200 / ts;
	if (vy <= -0x200 / ts)
		vy = -0x200 / ts;
	//ִ˶
	Entity::Step();
	//еذλ
	int i = 0;
	for (auto& e : floorArr)
	{
		auto we = e.lock();
		if (we)
		{
			we->x = x + i * 16 + offsetX;
			we->y = y;
			we->last_x = last_x + i * 16 + offsetX;
			we->last_y = last_y;
		}
		i++;
	}
}

void CS_Boss_SoapKingMagicFloor_FloatFloor::Disappear()
{
	for (auto& floor : floorArr)
	{
		auto wfloor = floor.lock();
		if (wfloor)
		{
			wfloor->SetEffect();
			wfloor->Destroy();
		}
 	}
	floorArr.clear();
	Destroy();
}

void CS_Boss_SoapKingMagicFloor_FloatFloor::Destroy()
{
	for (auto& floor : floorArr)
	{
		auto wfloor = floor.lock();
		if (wfloor)
			wfloor->Destroy();
	}
	floorArr.clear();
	Entity::Destroy();
}

std::weak_ptr<CS_Boss_SoapKingMagicFloor_FloatFloor> SetCS_Boss_SoapKingMagicFloor_FloatFloor(std::shared_ptr<Entity> parent, float x, float y)
{
	auto am = std::make_shared<CS_Boss_SoapKingMagicFloor_FloatFloor>(parent, x, y);
	parent->gameFunc->SetEntity(parent, am);
	return am;
}
