#include "CS_Boss_SoapKingMagicFloor.h"
#include "CS_PeSmoke.h"
CS_Boss_SoapKingMagicFloor::CS_Boss_SoapKingMagicFloor(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	el.name = CS_BOSS_SOAPKINGMAGICFLOOR_CREATENAME;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_magic_floor";
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	cbRect.left = 8;
	cbRect.right = 8;
	cbRect.top = 8;
	cbRect.bottom = 8;
	speedDir = true;
}

void CS_Boss_SoapKingMagicFloor::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	SetEffect();
	Entity::Init(self);
}

void CS_Boss_SoapKingMagicFloor::Step()
{
	if (usingAtk)
	{
		//һײ
		Entity::ClearCollisionResult();
		//ִ˶
		Entity::Step();
		//ִײ
		Entity::Collision();
		//ǽʧ
		if (cbRect.enableSoild)
		{
			cbRect.enableSoild = false;
		}
		else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
		{
			SetEffect();
			Destroy();
		}
		//ʧ
		if (action_timecounter > 0)
		{
			action_timecounter--;
			if (action_timecounter == 0)
			{
				SetEffect();
				Destroy();
			}
		}

	}
	else
	{
		attackState = true;
	}
}

bool CS_Boss_SoapKingMagicFloor::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	*outRealDamage = 0;
	return true;
}

void CS_Boss_SoapKingMagicFloor::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->ignoreTrap_counter > 0)
			return;
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outDamage = usingAtk ? 10 : 1;
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x400 / ts;
	*outHeavy = 2;
}

void CS_Boss_SoapKingMagicFloor::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	auto wdst = target.lock();
	if (wdst)
	{
		if (realDamage > 0)
			wdst->ignoreTrap_counter = 180;
	}
}

void CS_Boss_SoapKingMagicFloor::SetEffect()
{
	//
	for (size_t i = 0; i < 2; i++)
	{
		float offset_x = (float)Random((int)-cbRect.left, (int)cbRect.right);
		float offset_y = (float)Random((int)-cbRect.top, (int)cbRect.bottom);
		auto e = std::make_shared<CS_PeSmoke>();
		e->x = x + offset_x;
		e->y = y + offset_y;
		gameFunc->SetEntity(shared_from_this(), e);
	}
	gameFunc->PlaySound(L"CS_012_block_destroy");
}

void CS_Boss_SoapKingMagicFloor::ShootToTarget(std::weak_ptr<Entity> target)
{
	auto wtarget = target.lock();
	if (wtarget)
	{
		//÷ٶ
		XMVECTOR vec = XMVector2Normalize(XMVectorSet(wtarget->x - x, wtarget->y - y, 0, 0));
		float speed = 0x800 / ts;
		if(bNormalMode)
			speed = 0x400 / ts;
		vx = speed * XMVectorGetX(vec);
		vy = speed * XMVectorGetY(vec);
		attackState = true;
		usingAtk = true;
		action_timecounter = 300;
		cbRect.enableCbRect = true;
		cbRect.enableSoild = true;
		cbRect.enableSelfSoild = false;
		cbRect.enableMovePlatform = false;
	}
	else
	{
		SetEffect();
		Destroy();
	}
}

void CS_Boss_SoapKingMagicFloor::PressToTarget(float vx, float vy)
{
	this->vx = vx;
	this->vy = vy;
	attackState = true;
	usingAtk = true;
	action_timecounter = 300;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = false;
	cbRect.enableMovePlatform = false;
}

std::weak_ptr<CS_Boss_SoapKingMagicFloor> SetCS_Boss_SoapKingMagicFloor(std::shared_ptr<Entity> parent, float x, float y)
{
	auto am = std::make_shared<CS_Boss_SoapKingMagicFloor>(parent);
	am->x = x;
	am->y = y;
	parent->gameFunc->SetEntity(parent, am);
	return am;
}
